#
# Copyright INRA-URGI 2009-2012
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
import re
import sys
from commons.core.parsing.TranscriptListParser import TranscriptListParser
from SMART.Java.Python.structure.Transcript import Transcript
from SMART.Java.Python.structure.Interval import Interval
from SMART.Java.Python.ncList.NCList import NCList
from SMART.Java.Python.ncList.NCListCursor import NCListCursor
from SMART.Java.Python.ncList.NCListFilePickle import NCListFileUnpickle
from SMART.Java.Python.misc.UnlimitedProgress import UnlimitedProgress
try:
   import cPickle as pickle
except:
   import pickle


class NCListParser(TranscriptListParser):


	def __init__(self, fileName, verbosity = 0):
		self.title = None
		TranscriptListParser.__init__(self, fileName, verbosity)
		self.parse()

	def getFileFormats():
		return ["nclist"]
	getFileFormats = staticmethod(getFileFormats)

	def skipFirstLines(self):
		return

	def parse(self):
		handle                       = open(self.fileName)
		self.sortedFileNames         = pickle.load(handle)
		self.nbElements	             = pickle.load(handle)
		self.nbElementsPerChromosome = pickle.load(handle)
		self.ncLists                 = pickle.load(handle)
		for ncList in self.ncLists.values():
			ncList._reopenFiles()
		handle.close()
		self.chromosomes     = sorted(self.nbElementsPerChromosome.keys())
		self.fileNames       = dict([chromosome, self.ncLists[chromosome]._transcriptFileName] for chromosome in self.chromosomes)
		self.currentReader   = None
		self.currentChrIndex = 0

	def getSortedFileNames(self):
		return self._sortedFileNames

	def getNbElements(self):
		return self._nbElements

	def getNbElementsPerChromosome(self):
		return self._nbElementsPerChromosome

	def getNCLists(self):
		return self._ncLists
	
	def reset(self):
		self.currentChrIndex = 0
		self.currentReader   = None

	def gotoAddress(self, address):
		self.currentReader.gotoAddress(address)

	def getCurrentAddress(self):
		return self.getCurrentTranscriptAddress()

	def getCurrentTranscriptAddress(self):
		if self.currentReader == None:
			return 0
		return self.currentReader.getCurrentTranscriptAddress()

	def getNextTranscript(self):
		if self.currentReader == None:
			self.currentReader = NCListFileUnpickle(self.fileNames[self.chromosomes[0]])
		transcript = self.currentReader.getNextTranscript()
		if transcript == False:
			self.currentChrIndex += 1
			if self.currentChrIndex >= len(self.chromosomes):
				return None
			self.currentReader = NCListFileUnpickle(self.fileNames[self.chromosomes[self.currentChrIndex]])
			transcript = self.currentReader.getNextTranscript()
		return transcript

	def getInfos(self):
		self.size = 0
		self.reset()
		progress = UnlimitedProgress(100000, "Getting information on %s." % (self.fileName), self.verbosity-9)
		transcript = self.getNextTranscript()
		for transcript in self.getIterator():
			self.size += transcript.getSize()
			progress.inc()
		progress.done()
		self.reset()

	def getNbTranscripts(self):
		return self.nbElements
