from commons.core.checker.ConfigChecker import ConfigChecker 
from commons.core.checker.ConfigChecker import ConfigRules
from commons.core.checker.RepetException import RepetException
import os
import unittest

class Test_ConfigChecker(unittest.TestCase):
    
    def setUp(self):
        self._configFileName = "testConfigChecker.cfg"
        self._iMock = MockConfig()
     
    def test_checkIfExistsConfigFile_file_exist(self):
        f=open(self._configFileName, "w")
        f.close()
        
        doesFileExists = True
        iConfigRules = ConfigRules()
        try:
            iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
            iConfigChecker.checkIfExistsConfigFile()
        except RepetException:
            doesFileExists = False
        os.remove(self._configFileName)        
        self.assertTrue(doesFileExists)
        
    def test_checkIfExistsConfigFile_file_not_exist(self):
        iConfigRules = ConfigRules()
        expMsg ="CONFIG FILE not found - '%s'" %self._configFileName
        doesFileExists = True
        try:
            iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)   
            iConfigChecker.checkIfExistsConfigFile()     
        except RepetException, re:
            doesFileExists = False
        self.assertFalse(doesFileExists)
        self.assertEqual(expMsg, re.getMessage())
        
    def test_readConfigFile(self):
        self._iMock.write_config(self._configFileName)
        iConfigRules = ConfigRules()
        expDictRawConfigValues = {"dir_name" : {"work_dir":"toto"},
                                  "organism" : {"abbreviation":"T.aestivum",
                                                "genus":"triticum",
                                                "species":"aestivum",
                                                "common_name":"wheat",
                                                "comment":""},
                                  'analysis1': {'description': '',
                                                'gff_name': 'BLASTX.gff2',
                                                'name': 'BLASTXWheat2',
                                                'program': 'BLASTX2',
                                                'programversion': '3.32',
                                                'sourcename': 'dummyDesc_BLASTX2'}
                                 }
        isNoExceptionRaised = True
        try: 
            iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
            iConfig = iConfigChecker.readConfigFile()
            iConfigChecker.setRawConfig(iConfig)
            obsDictRawConfigValues = iConfigChecker._iRawConfig.dOptionsValues4Sections
        except RepetException:
            isNoExceptionRaised = False
        os.remove(self._configFileName)
        self.assertTrue(isNoExceptionRaised)
        self.assertEquals(obsDictRawConfigValues, expDictRawConfigValues)
        
    def test_readConfigFile_section_define_twice(self):
        self._iMock.write_case_section_define_twice(self._configFileName)
        iConfigRules = ConfigRules()
        expMsg = "Duplicate section exist in config file %s"  %self._configFileName
        expDictRawConfigValues = {"dir_name": {"work_dir":"toto"},
                                  "analysis1" : {"name": "BLASTXWheat2",
                                                 "program" : "BLASTX2",
                                                 "programversion" : "3.32",
                                                 "sourcename" :"dummyDesc_BLASTX2",
                                                 "description" : "",
                                                 "gff_name" :"BLASTX.gff2"}
                                 }
        doesNoExceptionRaised = True
        try:
            iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
            iConfig = iConfigChecker.readConfigFile()
            iConfigChecker.setRawConfig(iConfig)
            obsDictRawConfigValues = iConfigChecker._iRawConfig.dOptionsValues4Sections
        except RepetException, re:
            doesNoExceptionRaised = False
        os.remove(self._configFileName)
#       self.assertFalse(doesNoExceptionRaised)
#       self.assertEqual(expMsg, re.getMessage())
#
        self.assertTrue(doesNoExceptionRaised)
        self.assertEquals(obsDictRawConfigValues, expDictRawConfigValues)

    def test_readConfigFile_option_define_twice(self):
        self._iMock.write_case_option_define_twice(self._configFileName)
        iConfigRules = ConfigRules()
        doesNoExceptionRaised = True
        expDictRawConfigValues = {"dir_name": {"work_dir":"toto"},
                                  "analysis1" : {"name": "BLASTXWheat",
                                       "program" : "BLASTX2",
                                       "programversion" : "3.3",
                                       "sourcename" :"dummyDesc_BLASTX",
                                       "description" : "",
                                       "gff_name" :"BLASTX.gff"}
                    }
        try:
            iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
            iConfig = iConfigChecker.readConfigFile()
            iConfigChecker.setRawConfig(iConfig)
            obsDictRawConfigValues = iConfigChecker._iRawConfig.dOptionsValues4Sections
        except RepetException, re:
            doesNoExceptionRaised = False
        os.remove(self._configFileName)
##       self.assertFalse(doesNoExceptionRaised)
##       self.assertEqual(expMsg, re.getMessage())

        self.assertTrue(doesNoExceptionRaised)
        self.assertEquals(obsDictRawConfigValues, expDictRawConfigValues)
       
    def test_checkMandatorySections(self):
        self._iMock.write_config(self._configFileName)
        iConfigRules = ConfigRules()
        iConfigRules.addRuleSection(section="dir_name", mandatory=True)
        iConfigRules.addRuleSection(section="organism", mandatory=True)
        iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
        iConfig = iConfigChecker.readConfigFile()
        iConfigChecker.setRawConfig(iConfig)
        iConfigChecker.extendConfigRulesWithPatternRules()
        areAllMandatorySectionsFound = True
        try:
            iConfigChecker.checkMandatorySections()
        except RepetException:
            areAllMandatorySectionsFound = False
        os.remove(self._configFileName)
        self.assertTrue(areAllMandatorySectionsFound)
 
    def test_checkMandatorySections_one_missing (self):
        self._iMock.write_config(self._configFileName)
        iConfigRules = ConfigRules()
        iConfigRules.addRuleSection(section="dir_name", mandatory=True)
        iConfigRules.addRuleSection(section="target", mandatory=True)
        iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
        iConfig = iConfigChecker.readConfigFile()
        iConfigChecker.setRawConfig(iConfig)
        iConfigChecker.extendConfigRulesWithPatternRules()
        expMsg = "Error in configuration file %s, following sections are missing:\n - target\n"% self._configFileName
        areAllMandatorySectionsFound = True
        try:
            iConfigChecker.checkMandatorySections()
        except RepetException, re:
            areAllMandatorySectionsFound = False
        os.remove(self._configFileName)
        self.assertFalse(areAllMandatorySectionsFound)
        self.assertEquals(expMsg, re.getMessage())
        
    def test_checkMandatorySections_mandatory_section_with_pattern_section_is_missing (self):
        self._iMock.write_config(self._configFileName)
        iConfigRules = ConfigRules()
        iConfigRules.addRuleSection(section="dir_name", mandatory=True)
        iConfigRules.addRuleSection(section="mandatorySection", mandatory=True, isPattern = True)
        iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
        iConfig = iConfigChecker.readConfigFile()
        iConfigChecker.setRawConfig(iConfig)
        iConfigChecker.extendConfigRulesWithPatternRules()
        expMsg = "Error in configuration file %s, following sections are missing:\n - mandatorySection\n"% self._configFileName 
        areAllMandatorySectionsFound = True
        try:
            iConfigChecker.checkMandatorySections()
        except RepetException, re:
            areAllMandatorySectionsFound = False
        os.remove(self._configFileName)
        self.assertFalse(areAllMandatorySectionsFound)
        self.assertEquals(expMsg, re.getMessage())

    def test_checkMandatorySections_mandatory_section_is_pattern (self):
        self._iMock.write_case_pattern_rule(self._configFileName)
        iConfigRules = ConfigRules()
        iConfigRules.addRuleSection(section="dir_name", mandatory=True)
        iConfigRules.addRuleSection(section="analysis[0-9]*", mandatory=True, isPattern = True)
        iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
        iConfig = iConfigChecker.readConfigFile()
        iConfigChecker.setRawConfig(iConfig)
        iConfigChecker.extendConfigRulesWithPatternRules()
        areAllMandatorySectionsFound = True
        try:
            iConfigChecker.checkMandatorySections()
        except RepetException:
            areAllMandatorySectionsFound = False
        os.remove(self._configFileName)
        self.assertTrue(areAllMandatorySectionsFound)

    def test_checkMandatoryOptions_in_mandatory_section (self):
        self._iMock.write_config(self._configFileName)
        iConfigRules = ConfigRules()
        iConfigRules.addRuleSection(section="organism", mandatory=True)
        iConfigRules.addRuleOption(section="organism", option ="genus", mandatory=True)
        iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
        iConfig = iConfigChecker.readConfigFile()
        iConfigChecker.setRawConfig(iConfig)
        iConfigChecker.extendConfigRulesWithPatternRules()
        areAllMandatoryOptionsFound = True
        try:
            iConfigChecker.checkMandatoryOptions()
        except RepetException:
            areAllMandatoryOptionsFound = False
        os.remove(self._configFileName)
        self.assertTrue(areAllMandatoryOptionsFound)

    def test_checkMandatoryOptions_in_mandatory_section_option_is_missing (self):
        self._iMock.write_config(self._configFileName)
        iConfigRules = ConfigRules()
        iConfigRules.addRuleSection(section="organism", mandatory=True)
        iConfigRules.addRuleOption(section="organism", option ="MissingOption", mandatory=True)
        iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
        iConfig = iConfigChecker.readConfigFile()
        iConfigChecker.setRawConfig(iConfig)
        iConfigChecker.extendConfigRulesWithPatternRules()
        expMsg = "Error in configuration file %s, following options are missing: \n - [organism]: MissingOption\n" % self._configFileName
        areAllMandatoryOptionsFound = True
        try:
            iConfigChecker.checkMandatoryOptions()
        except RepetException, re:
            areAllMandatoryOptionsFound = False
        os.remove(self._configFileName)
        self.assertFalse(areAllMandatoryOptionsFound)
        self.assertEquals(expMsg, re.getMessage())

    def test_checkMandatoryOptions_in_non_mandatory_section_and_section_and_option_exist (self):
        self._iMock.write_config(self._configFileName)
        iConfigRules = ConfigRules()
        iConfigRules.addRuleOption(section="organism", option ="genus", mandatory=True)
        iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
        iConfig = iConfigChecker.readConfigFile()
        iConfigChecker.setRawConfig(iConfig)
        iConfigChecker.extendConfigRulesWithPatternRules()
        areAllMandatoryOptionsFound = True
        try:
            iConfigChecker.checkMandatoryOptions()
        except RepetException:
            areAllMandatoryOptionsFound = False
        os.remove(self._configFileName)
        self.assertTrue(areAllMandatoryOptionsFound)
        
    def test_checkMandatoryOptions_in_non_mandatory_section_and_section_exist_option_is_missing (self):
        self._iMock.write_config(self._configFileName)
        iConfigRules = ConfigRules()
        iConfigRules.addRuleOption(section="organism", option ="MissingOption", mandatory=True)
        iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
        iConfig = iConfigChecker.readConfigFile()
        iConfigChecker.setRawConfig(iConfig)
        iConfigChecker.extendConfigRulesWithPatternRules()
        expMsg = "Error in configuration file %s, following options are missing: \n - [organism]: MissingOption\n" % self._configFileName
        areAllMandatoryOptionsFound = True
        try:
            iConfigChecker.checkMandatoryOptions()
        except RepetException, re:
            areAllMandatoryOptionsFound = False
        os.remove(self._configFileName)
        self.assertFalse(areAllMandatoryOptionsFound)
        self.assertEquals(expMsg,re.getMessage())
        
    def test_checkMandatoryOptions_in_non_mandatory_section_and_section_does_not_exist (self):
        self._iMock.write_config(self._configFileName)
        iConfigRules = ConfigRules()
        iConfigRules.addRuleOption(section="NonExistingAndNonMandatorySection", option ="genus", mandatory=True)
        iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
        iConfig = iConfigChecker.readConfigFile()
        iConfigChecker.setRawConfig(iConfig)
        iConfigChecker.extendConfigRulesWithPatternRules()
        areAllMandatoryOptionsFound = True
        try:
            iConfigChecker.checkMandatoryOptions()
        except RepetException:
            areAllMandatoryOptionsFound = False
        os.remove(self._configFileName)
        self.assertTrue(areAllMandatoryOptionsFound)
        
    def test_checkMandatoryOptions_with_Pattern_rules_in_section  (self):
        self._iMock.write_case_pattern_rule(self._configFileName)
        iConfigRules = ConfigRules()
        iConfigRules.addRuleSection(section="analysis", isPattern=True)
        iConfigRules.addRuleOption(section="analysis", option ="name", mandatory=True)
        iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
        iConfig = iConfigChecker.readConfigFile()
        iConfigChecker.setRawConfig(iConfig)
        iConfigChecker.extendConfigRulesWithPatternRules()
        areAllMandatoryOptionsFound = True
        try:
            iConfigChecker.checkMandatoryOptions()
        except RepetException:
            areAllMandatoryOptionsFound = False
        os.remove(self._configFileName)
        self.assertTrue(areAllMandatoryOptionsFound)

    def test_checkMandatoryOptions_with_pattern_rules_in_option_section_is_mandatory (self):
        self._iMock.write_case_pattern_rule(self._configFileName)
        iConfigRules = ConfigRules()
        iConfigRules.addRuleSection(section="section_with_option_pattern", mandatory=True)
        iConfigRules.addRuleOption(section="section_with_option_pattern", option ="option", isPattern= True, mandatory=True)
        iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
        iConfig = iConfigChecker.readConfigFile()
        iConfigChecker.setRawConfig(iConfig)
        iConfigChecker.extendConfigRulesWithPatternRules()
        areAllMandatoryOptionsFound = True
        try:
            iConfigChecker.checkMandatoryOptions()
        except RepetException:
            areAllMandatoryOptionsFound = False
        os.remove(self._configFileName)
        self.assertTrue(areAllMandatoryOptionsFound)

    def test_checkMandatoryOptions_with_pattern_rules_in_option_in_mandatory_section_option_is_missing (self):
        self._iMock.write_case_pattern_rule(self._configFileName)
        iConfigRules = ConfigRules()
        iConfigRules.addRuleSection(section="section_with_option_pattern", mandatory=True)
        iConfigRules.addRuleOption(section="section_with_option_pattern", option ="MissingOption", isPattern= True, mandatory=True)
        iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
        iConfig = iConfigChecker.readConfigFile()
        iConfigChecker.setRawConfig(iConfig)
        iConfigChecker.extendConfigRulesWithPatternRules()
        expMsg = "Error in configuration file %s, following options are missing: \n - [section_with_option_pattern]: MissingOption\n" % self._configFileName
        areAllMandatoryOptionsFound = True
        try:
            iConfigChecker.checkMandatoryOptions()
        except RepetException, re:
            areAllMandatoryOptionsFound = False
        os.remove(self._configFileName)
        self.assertFalse(areAllMandatoryOptionsFound)
        self.assertEquals(expMsg, re.getMessage())

    def test_checkMandatoryOptions_with_pattern_rules_in_non_mandatory_section_and_section_and_option_exist (self):
        self._iMock.write_case_pattern_rule(self._configFileName)
        iConfigRules = ConfigRules()
        iConfigRules.addRuleOption(section="section_with_option_pattern", option ="option", isPattern= True, mandatory=True)
        iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
        iConfig = iConfigChecker.readConfigFile()
        iConfigChecker.setRawConfig(iConfig)
        iConfigChecker.extendConfigRulesWithPatternRules()
        areAllMandatoryOptionsFound = True
        try:
            iConfigChecker.checkMandatoryOptions()
        except RepetException:
            areAllMandatoryOptionsFound = False
        os.remove(self._configFileName)
        self.assertTrue(areAllMandatoryOptionsFound)
        
    def test_checkMandatoryOptions_with_pattern_rules_in_non_mandatory_section_and_section_exist_option_is_missing (self):
        self._iMock.write_case_pattern_rule(self._configFileName)
        iConfigRules = ConfigRules()
        iConfigRules.addRuleOption(section="section_with_option_pattern", option ="MissingOption", isPattern= True, mandatory=True)
        iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
        iConfig = iConfigChecker.readConfigFile()
        iConfigChecker.setRawConfig(iConfig)
        iConfigChecker.extendConfigRulesWithPatternRules()
        expMsg = "Error in configuration file %s, following options are missing: \n - [section_with_option_pattern]: MissingOption\n" % self._configFileName
        areAllMandatoryOptionsFound = True
        try:
            iConfigChecker.checkMandatoryOptions()
        except RepetException, re:
            areAllMandatoryOptionsFound = False
        os.remove(self._configFileName)
        self.assertFalse(areAllMandatoryOptionsFound)
        self.assertEquals(expMsg,re.getMessage())
        
    def test_checkMandatoryOptions_with_pattern_rules_in_non_mandatory_section_and_section_does_not_exist (self):
        self._iMock.write_case_pattern_rule(self._configFileName)
        iConfigRules = ConfigRules()
        iConfigRules.addRuleOption(section="non_mandatory_section", option ="MissingOption", isPattern= True, mandatory=True)
        iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
        iConfig = iConfigChecker.readConfigFile()
        iConfigChecker.setRawConfig(iConfig)
        iConfigChecker.extendConfigRulesWithPatternRules()
        areAllMandatoryOptionsFound = True
        try:
            iConfigChecker.checkMandatoryOptions()
        except RepetException:
            areAllMandatoryOptionsFound = False
        os.remove(self._configFileName)
        self.assertTrue(areAllMandatoryOptionsFound)
        
    def test_checkMandatoryOptions_with_pattern_rules_for_both_section_and_option  (self):
        self._iMock.write_case_pattern_rule(self._configFileName)
        iConfigRules = ConfigRules()
        iConfigRules.addRuleSection(section="section_with_option_pattern", isPattern=True)
        iConfigRules.addRuleOption(section="section_with_option_pattern", option ="option", isPattern= True, mandatory=True)
        iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
        iConfig = iConfigChecker.readConfigFile()
        iConfigChecker.setRawConfig(iConfig)
        iConfigChecker.extendConfigRulesWithPatternRules()
        areAllMandatoryOptionsFound = True
        try:
            iConfigChecker.checkMandatoryOptions()
        except RepetException:
            areAllMandatoryOptionsFound = False
        os.remove(self._configFileName)
        self.assertTrue(areAllMandatoryOptionsFound)
       
    def test_checkMandatoryOptions_case(self):
        self._iMock.write_config_case(self._configFileName)
        iConfigRules = ConfigRules()
        iConfigRules.addRuleSection("dir_name", True)
        iConfigRules.addRuleSection("organism", True)
        iConfigRules.addRuleOption("organism", "min_SSR_coverage", True)
        iConfigChecker = ConfigChecker(self._configFileName, iConfigRules)
        iConfig = iConfigChecker.readConfigFile()
        iConfigChecker.setRawConfig(iConfig)
        iConfigChecker.extendConfigRulesWithPatternRules()
        areAllMandatorySectionsFound = True
        try:
            iConfigChecker.checkMandatoryOptions()
        except RepetException:
            areAllMandatorySectionsFound = False
        os.remove(self._configFileName)
        self.assertTrue(areAllMandatorySectionsFound)

#TODO Test de extendConfigRulesWithPatternRules et de applyRuleToRawValue
# option avec une liste de valeurs possibles dans un ensemble
# option type=string type="num" type="date"???.
#option define twice and options use in other
             
class MockConfig (object):
    
    def write_config(self, configFileName):
        configF = open(configFileName, "w" )
        configF.write( "[dir_name]\n")
        configF.write( "work_dir : toto \n") 
        configF.write( "\n")
        configF.write( "[organism]\n")
        configF.write( "abbreviation: T.aestivum\n")
        configF.write( "genus: triticum\n")
        configF.write( "species: aestivum\n")
        configF.write( "common_name: wheat\n")
        configF.write( "comment: \n")
        configF.write( "[analysis1]\n")
        configF.write( "name: BLASTXWheat2\n")
        configF.write( "program: BLASTX2\n")
        configF.write( "programversion: 3.32\n")
        configF.write( "sourcename: dummyDesc_BLASTX2\n")
        configF.write( "description: \n")
        configF.write( "gff_name: BLASTX.gff2\n")
        configF.write( "\n")
        configF.close()
        
    def write_case_section_define_twice(self, configFileName):
        configF = open(configFileName, "w" )
        configF.write( "[dir_name]\n")
        configF.write( "work_dir : toto \n") 
        configF.write( "\n")
        configF.write( "[analysis1]\n")
        configF.write( "name: BLASTXWheat\n")
        configF.write( "program: BLASTX\n")
        configF.write( "programversion: 3.3\n")
        configF.write( "sourcename: dummyDesc_BLASTX\n")
        configF.write( "description: \n")
        configF.write( "gff_name: BLASTX.gff\n")
        configF.write( "\n")
        configF.write( "[analysis1]\n")
        configF.write( "name: BLASTXWheat2\n")
        configF.write( "program: BLASTX2\n")
        configF.write( "programversion: 3.32\n")
        configF.write( "sourcename: dummyDesc_BLASTX2\n")
        configF.write( "description: \n")
        configF.write( "gff_name: BLASTX.gff2\n")
        configF.write( "\n")
        configF.close()
        
    def write_case_option_define_twice(self, configFileName):
        configF = open(configFileName, "w" )
        configF.write( "[dir_name]\n")
        configF.write( "work_dir : toto \n") 
        configF.write( "\n")
        configF.write( "[analysis1]\n")
        configF.write( "name: BLASTXWheat\n")
        configF.write( "program: BLASTX\n")
        configF.write( "programversion: 3.3\n")
        configF.write( "sourcename: dummyDesc_BLASTX\n")
        configF.write( "program: BLASTX2\n")
        configF.write( "description: \n")
        configF.write( "gff_name: BLASTX.gff\n")
        configF.write( "\n")
        configF.write( "\n")
        configF.close()
        
    #configuration file with section with option depends on presence of other options
    def write_with_one_option_depends_of_an_other_one(self, configFileName ):
        configF = open(configFileName, "w" )
        configF.write( "[dir_name]\n")
        configF.write( "work_dir : toto\n") 
        configF.write( "\n")
        configF.write( "[organism]\n")
        configF.write( "abbreviation: T.aestivum\n")
        configF.write( "genus: Triticum\n")
        configF.write( "species: aestivum\n")
        configF.write( "common_name: wheat\n")
        configF.write( "comment: \n")
        configF.write( "\n")
        configF.write( "[analysis1]\n")
        configF.write( "name: BLASTXWheat\n")
        configF.write( "program: BLASTX\n")
        configF.write( "programversion: 3.3\n")
        configF.write( "sourcename: src_BLASTX\n")
        configF.write( "description: \n")
        configF.write( "gff_name: BLASTX.gff\n")
        configF.write( "\n")
        configF.write( "[analysis2]\n")
        configF.write( "name: GMHMMWheat\n")
        configF.write( "program: GMHMM\n")
        configF.write( "programversion: 4.3\n")
        configF.write( "sourcename: src_GMHMM\n")
        configF.write( "description: \n")
        configF.write( "gff_name: GMHMM.gff\n")
        configF.write( "\n")
        configF.write( "[target]\n")
        configF.write( "target_used: yes\n")
        configF.write( "target_used_list: target.lst\n")
        configF.close()
        
    def write_case_pattern_rule(self, configFileName ):
        configF = open(configFileName, "w" )
        configF.write( "[dir_name]\n")
        configF.write( "work_dir : toto\n" ) 
        configF.write( "\n")
        configF.write( "[organism]\n")
        configF.write( "abbreviation: T.aestivum\n")
        configF.write( "genus: Triticum\n")
        configF.write( "species: aestivum\n")
        configF.write( "common_name: wheat\n")
        configF.write( "comment: \n")
        configF.write( "\n")
        configF.write( "[analysis1]\n")
        configF.write( "name: BLASTXWheat\n")
        configF.write( "program: BLASTX\n")
        configF.write( "programversion: 3.3\n")
        configF.write( "sourcename: src_BLASTX\n")
        configF.write( "description: \n")
        configF.write( "gff_name: BLASTX.gff\n")
        configF.write( "\n")
        configF.write( "[analysis2]\n")
        configF.write( "name: GMHMMWheat\n")
        configF.write( "program: GMHMM\n")
        configF.write( "programversion: 4.3\n")
        configF.write( "sourcename: src_GMHMM\n")
        configF.write( "description: \n")
        configF.write( "gff_name: GMHMM.gff\n")
        configF.write( "\n")
        configF.write( "[target]\n")
        configF.write( "target_used: yes\n")
        configF.write( "target_used_list: target.lst\n")
        configF.write( "\n")
        configF.write( "[section_with_option_pattern]\n")
        configF.write( "option1: value1\n")
        configF.write( "option2: value2\n")
        configF.write( "[second_section_with_option_pattern]\n")
        configF.write( "option1: value1\n")
        configF.write( "option2: value2\n")
        configF.close()
        
    def write_config_case(self, configFileName):
        configF = open(configFileName, "w" )
        configF.write( "[dir_name]\n")
        configF.write( "work_dir : toto \n") 
        configF.write( "\n")
        configF.write( "[organism]\n")
        configF.write( "min_SSR_coverage: 0.50\n")
        configF.write( "\n")
        configF.close()
        
if __name__ == "__main__":
    unittest.main()