import unittest
from commons.core.launcher.LauncherUtils import LauncherUtils

class Test_LauncherUtils(unittest.TestCase):
        
    def test_createHomogeneousSizeList_empty(self):
        lHeadersSizeTuples = []
        maxSize = 500
        expLHeadersList = []
        obsLHeadersList = LauncherUtils.createHomogeneousSizeList(lHeadersSizeTuples, maxSize)
        self.assertEquals(expLHeadersList, obsLHeadersList)
        
    def test_createHomogeneousSizeList_one_item_upper_mean(self):
        lHeadersSizeTuples = [("h1", 300)]
        maxSize = 500
        expLHeadersList = [["h1"]]
        obsLHeadersList = LauncherUtils.createHomogeneousSizeList(lHeadersSizeTuples, maxSize)
        self.assertEquals(expLHeadersList, obsLHeadersList)
        
    def test_createHomogeneousSizeList_one_item_under_mean(self):
        lHeadersSizeTuples = [("h1", 100)]
        maxSize = 500
        expLHeadersList = [["h1"]]
        obsLHeadersList = LauncherUtils.createHomogeneousSizeList(lHeadersSizeTuples, maxSize)
        self.assertEquals(expLHeadersList, obsLHeadersList)
        
    def test_createHomogeneousSizeList_3items(self):
        lHeadersSizeTuples = [("h1", 250),
                              ("h2", 250),
                              ("h3", 300)]
        maxSize = 500
        expLHeadersList = [["h3"], ["h2"], ["h1"]]
        obsLHeadersList = LauncherUtils.createHomogeneousSizeList(lHeadersSizeTuples, maxSize)
        self.assertEquals(expLHeadersList, obsLHeadersList)

    def test_createHomogeneousSizeList_4items(self):
        lHeadersSizeTuples = [("h1", 100),
                              ("h2", 200),
                              ("h3", 10),
                              ("h4", 400)]
        maxSize = 500
        expLHeadersList = [["h4", "h3"], ["h2", "h1"]]
        obsLHeadersList = LauncherUtils.createHomogeneousSizeList(lHeadersSizeTuples, maxSize)
        self.assertEquals(expLHeadersList, obsLHeadersList)
        
    def test_createHomogeneousSizeList_5items(self):
        lHeadersSizeTuples = [("h1", 300),
                              ("h2", 300),
                              ("h3", 250),
                              ("h4", 100),
                              ("h5", 90)]
        maxSize = 500
        expLHeadersList = [["h2", "h5","h4"], ["h1"], ["h3"]]
        obsLHeadersList = LauncherUtils.createHomogeneousSizeList(lHeadersSizeTuples, maxSize)
        self.assertEquals(expLHeadersList, obsLHeadersList)
        
    def test_createHomogeneousSizeList_all_upper_max(self):
        lHeadersSizeTuples = [("h1", 600),
                              ("h2", 500),
                              ("h3", 700),
                              ("h4", 900),
                              ("h5", 500)]
        maxSize = 500
        expLHeadersList = [["h4"], ["h3"], ["h1"], ["h5"], ["h2"]]
        obsLHeadersList = LauncherUtils.createHomogeneousSizeList(lHeadersSizeTuples, maxSize)
        self.assertEquals(expLHeadersList, obsLHeadersList)
        
    def test_createHomogeneousSizeList_all_upper_mean(self):
        lHeadersSizeTuples = [("h1", 300),
                              ("h2", 300),
                              ("h3", 300),
                              ("h4", 300),
                              ("h5", 300)]
        maxSize = 500
        expLHeadersList = [["h5"], ["h4"], ["h3"], ["h2"], ["h1"]]
        obsLHeadersList = LauncherUtils.createHomogeneousSizeList(lHeadersSizeTuples, maxSize)
        self.assertEquals(expLHeadersList, obsLHeadersList)
        
    def test_createHomogeneousSizeList_all_under_mean(self):
        lHeadersSizeTuples = [("h1", 100),
                              ("h2", 100),
                              ("h3", 100),
                              ("h4", 100),
                              ("h5", 100)]
        maxSize = 500
        expLHeadersList = [["h5", "h4", "h3", "h2"], ["h1"]]
        obsLHeadersList = LauncherUtils.createHomogeneousSizeList(lHeadersSizeTuples, maxSize)
        self.assertEquals(expLHeadersList, obsLHeadersList)
        
    def test_createHomogeneousSizeList_floats(self):
        lHeadersSizeTuples = [("h1", 99.1),
                              ("h2", 100.7),
                              ("h3", 100.1),
                              ("h4", 100.1),
                              ("h5", 100)]
        maxSize = 500
        expLHeadersList = [['h2', 'h4', 'h3', 'h5'], ["h1"]]
        obsLHeadersList = LauncherUtils.createHomogeneousSizeList(lHeadersSizeTuples, maxSize)
        self.assertEquals(expLHeadersList, obsLHeadersList)

if __name__ == "__main__":
    unittest.main()