import unittest
import logging
from commons.core.LoggerFactory import LoggerFactory

class Test_LoggerFactory( unittest.TestCase ):
    
    def test_logger_debug(self):
        iLogger = LoggerFactory.createLogger("test")
        isMethodExecuted = True
        try:
            iLogger.debug("message")
        except:
            isMethodExecuted = False
        self.assertTrue(isMethodExecuted)
    
    def test_logger_info(self):
        iLogger = LoggerFactory.createLogger("test")
        isMethodExecuted = True
        try:
            iLogger.info("message")
        except:
            isMethodExecuted = False
        self.assertTrue(isMethodExecuted)
    
    def test_logger_warning(self):
        iLogger = LoggerFactory.createLogger("test")
        isMethodExecuted = True
        try:
            iLogger.warning("message")
        except:
            isMethodExecuted = False
        self.assertTrue(isMethodExecuted)
    
    def test_logger_error(self):
        iLogger = LoggerFactory.createLogger("test")
        isMethodExecuted = True
        try:
            iLogger.error("message")
        except:
            isMethodExecuted = False
        self.assertTrue(isMethodExecuted)
    
    def test_logger_level_debug(self):
        iLogger = LoggerFactory.createLogger("test")
        LoggerFactory.setLevel(iLogger, 4)
        expLevel = logging.DEBUG
        obsLevel = iLogger.getEffectiveLevel()
        self.assertEquals(expLevel, obsLevel)
    
    def test_logger_level_info(self):
        iLogger = LoggerFactory.createLogger("test")
        LoggerFactory.setLevel(iLogger, 3)
        expLevel = logging.INFO
        obsLevel = iLogger.getEffectiveLevel()
        self.assertEquals(expLevel, obsLevel)
    
    def test_logger_level_warning(self):
        iLogger = LoggerFactory.createLogger("test")
        LoggerFactory.setLevel(iLogger, 2)
        expLevel = logging.WARNING
        obsLevel = iLogger.getEffectiveLevel()
        self.assertEquals(expLevel, obsLevel)
    
    def test_logger_level_error(self):
        iLogger = LoggerFactory.createLogger("test")
        LoggerFactory.setLevel(iLogger, 1)
        expLevel = logging.ERROR
        obsLevel = iLogger.getEffectiveLevel()
        self.assertEquals(expLevel, obsLevel)
    
    def test_logger_default_level(self):
        iLogger = LoggerFactory.createLogger("test")
        expLevel = logging.ERROR
        obsLevel = iLogger.getEffectiveLevel()
        self.assertEquals(expLevel, obsLevel)
    
    def test_logger_quiet(self):
        iLogger = LoggerFactory.createLogger("test")
        LoggerFactory.setLevel(iLogger, 0)
        self.assertTrue(iLogger.disabled)
        
    def test_logger_noduplicate_handler(self):
        iLogger = LoggerFactory.createLogger("test")
        iLogger2 = LoggerFactory.createLogger("test")
        
        expNbHandlers = 1
        obsNbHandlers = len(iLogger2.handlers)
        self.assertEquals(expNbHandlers, obsNbHandlers)
        
test_suite = unittest.TestSuite()
test_suite.addTest( unittest.makeSuite( Test_LoggerFactory ) )
if __name__ == "__main__":
    unittest.TextTestRunner(verbosity=2).run( test_suite )