#! /usr/bin/env python
"""Convert a GFF with REPET format to BED format"""

import os
from optparse import OptionParser
from parsing.gffParser import *
from writer.bedWriter import *
from misc.progress import *


if __name__ == "__main__":
  
  # parse command line
  description = "Repet GFF Convert: Convert REPET-flavored GFF to normal GFF. [Category: Personnal]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",            dest="inputFileName",  action="store",                     type="string", help="input file [compulsory] [format: file in GFF3 format]")
  parser.add_option("-o", "--output",           dest="outputFileName", action="store",                     type="string", help="output file [compulsory] [format: output file in GFF3 format]")
  parser.add_option("-v", "--verbosity",        dest="verbosity",      action="store",      default=1,     type="int",    help="trace level [format: int]")
  (options, args) = parser.parse_args()

  parser      = GffParser(options.inputFileName, options.verbosity)
  transcripts = dict()
  progress    = Progress(parser.getNbTranscripts(), "Analyzing file %s" % (options.inputFileName), options.verbosity)
  for transcript in parser.getIterator():
    if transcript.feature.endswith("range"):
      transcripts[transcript.name] = transcript
    elif transcript.feature.endswith("hsp"):
      if transcript.name in transcripts:
        transcripts[transcript.name].addExon(transcript)
      else:
        sys.exit("Transcript %s is not defined\n" % (transcript.name))
    else:
      sys.exit("Do not understand feature %s" % (transcript.feature))
    progress.inc()
  progress.done()
    
  writer = BedWriter(options.outputFileName, options.verbosity)
  for name in transcripts:
    writer.addTranscript(transcripts[name])
    
  print "%d transcripts out of %d written (%.2f%%)" % (len(transcripts.keys()), parser.getNbTranscripts(), float(len(transcripts.keys())) / parser.getNbTranscripts() * 100)
