# densityPlot
# density plot of all samples

# input : counts, target, projectName
# output : densplot (png)

# created Feb 7th, 2012
# modified April 30th, 2012


densityPlot <- function( counts, group, OUT_densityPlotName, out = TRUE ){

  if (out) png( file=OUT_densityPlotName )

  couleurs <- as.integer( group ) + 1
  ylim <- c(0, max(density(log2(counts)+1)$y)*1.5)
  plot( density(log2(counts[,1])+1), main="Density of counts distribution", col=couleurs[1], ylim = ylim )
  for (i in 2:ncol(counts))
  	lines( density(log2(counts[,i])+1), col=couleurs[i] )
  legend( "topright", as.character(unique(group)), lty=1, col=as.integer(unique(group))+1 )

  if (out) dev.off()
}
