#! /usr/bin/env python
"""
Read a transcript file and convert it to another format
"""

import os
from optparse import OptionParser
from structure.transcriptContainer import *
from writer.transcriptWriter import *
from misc.progress import *


if __name__ == "__main__":
  
  # parse command line
  description = "Convert Transcript File: Convert a file from a format to another. [Category: Conversion]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",        dest="inputFileName",     action="store",                        type="string", help="input file [compulsory] [format: file in format given by -f]")
  parser.add_option("-f", "--inputFormat",  dest="inputFormat",       action="store",                        type="string", help="format of the input file [compulsory] [format: transcript file format]")
  parser.add_option("-o", "--output",       dest="outputFileName",    action="store",                        type="string", help="output file [compulsory] [format: output file in format given by -g]")
  parser.add_option("-g", "--outputFormat", dest="outputFormat",      action="store",                        type="string", help="format of the output file [compulsory] [format: transcript file format]")
  parser.add_option("-n", "--name",         dest="name",              action="store",      default="SMART",  type="string", help="name for the transcripts [format: string] [default: SMART]")
  parser.add_option("-v", "--verbosity",    dest="verbosity",         action="store",      default=1,        type="int",    help="trace level [format: int] [default: 1]")
  parser.add_option("-l", "--log",          dest="log",               action="store_true", default=False,                   help="write a log file [format: bool]")
  (options, args) = parser.parse_args()

  if options.log:
    logHandle = open(options.outputFileName + ".log", "w")

  # create parser
  parser = TranscriptContainer(options.inputFileName, options.inputFormat, options.verbosity)
    
  # create writer
  writer = TranscriptWriter(options.outputFileName, options.outputFormat, options.verbosity)
  writer.setContainer(parser)
    
  if options.name != None:
    writer.setTitle(options.name)
    
  nbItems = 0
  if options.verbosity > 0:
    nbItems = parser.getNbItems()
    print "%i items found" % (nbItems)

  # convert
  writer.write()
