#! /usr/bin/env python
"""Get the first element (exon / intron) from a list of transcripts"""

import os
from optparse import OptionParser
from writer.gff3Writer import *
from structure.transcriptContainer import *
from misc.progress import *


if __name__ == "__main__":
  
  # parse command line
  description = "Get Element: Get the first element (exon / intron) from a list of transcripts. [Category: Personnal]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",     dest="inputFileName",  action="store",                        type="string", help="input file [compulsory] [format: file in transcript format given by -f]")
  parser.add_option("-f", "--format",    dest="format",         action="store",                        type="string", help="format of file [compulsory] [format: transcript file format]")
  parser.add_option("-o", "--output",    dest="outputFileName", action="store",                        type="string", help="output file [compulsory] [format: output file in GFF3 format]")
  parser.add_option("-y", "--mysql",     dest="mysql",          action="store_true", default=False,                   help="mySQL output [format: bool] [default: false]")
  parser.add_option("-t", "--type",      dest="type",           action="store",                        type="string", help="type of the element  [format: choice (exon, intron)]")
  parser.add_option("-v", "--verbosity", dest="verbosity",      action="store",      default=1,        type="int",    help="trace level [format: int]")
  parser.add_option("-l", "--log",       dest="log",            action="store_true", default=False,                   help="write a log file [format: bool] [default: false]")
  (options, args) = parser.parse_args()

  parser    = TranscriptContainer(options.inputFileName, options.format, options.verbosity)
  writer    = Gff3Writer(options.outputFileName, options.verbosity)
  sqlWriter = MySqlTranscriptWriter(options.outputFileName, options.verbosity)
  
  nbLines = parser.getNbTranscripts()
  print "%i lines found" % (nbLines)

  # treat transcripts
  nbWritten = 0
  nbUsed    = 0
  progress  = Progress(nbLines, "Analyzing transcripts of " + options.inputFileName, options.verbosity)
  for transcript in parser.getIterator():

    outTranscript = Transcript()
    outTranscript.setName(transcript.name)
    outTranscript.setDirection(transcript.direction)
    outTranscript.setChromosome(transcript.chromosome)
    
    if options.type == "exon":
      if len(transcript.getExons()) > 1:
        transcript.sortExons()
        outTranscript.setStart(transcript.getExons()[0].start)
        outTranscript.setEnd(transcript.getExons()[0].end)
        writer.addTranscript(outTranscript)
        if options.mysql:
          sqlWriter.addTranscript(transcript)
        nbWritten += 1
        nbUsed    += 1
    elif options.type == "intron":
      used = False
      for intron in transcript.getIntrons():
        used = True
        thisTranscript = Transcript()
        thisTranscript.copy(outTranscript)
        thisTranscript.setStart(intron.start)
        thisTranscript.setEnd(intron.end)
        writer.addTranscript(thisTranscript)
        if options.mysql:
          sqlWriter.addTranscript(transcript)
        nbWritten += 1
      if used:
        nbUsed += 1
    else:
      sys.exit("Cannot understan type %s" % (options.type))
    progress.inc()
  progress.done()

  if options.mysql:
    sqlWriter.write()

  print "nb sequences used: %d" % (nbUsed)
  print "nb elements used: %d" % (nbWritten)
