#! /usr/bin/env python
"""Compare overlap of a transcript list and list of read, and get some info depending on the coverage"""

import os
from optparse import OptionParser
from parsing.sequenceListParser import *
from writer.gff3Writer import *
from mySql.mySqlConnection import *
from structure.transcriptListsComparator import *
from misc.rPlotter import *
from misc.progress import *


if __name__ == "__main__":
  
  # parse command line
  description = "Get Info per Coverage: Get a list of information clustered by the density of the coverage on a genome. [Category: Personnal]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input1",           dest="inputFileName1", action="store",                     type="string", help="input file 1 [compulsory] [format: file in transcript format given by -f]")
  parser.add_option("-f", "--format1",          dest="format1",        action="store",                     type="string", help="format of file 1 [compulsory] [format: transcript file format]")
  parser.add_option("-j", "--input2",           dest="inputFileName2", action="store",                     type="string", help="input file 2 [compulsory] [format: file in transcript format given by -g]")
  parser.add_option("-g", "--format2",          dest="format2",        action="store",                     type="string", help="format of file 2 [compulsory] [format: transcript file format]")
  parser.add_option("-o", "--output",           dest="output",         action="store",      default=None,  type="string", help="output file [compulsory] [format: output file in TXT format]")
  parser.add_option("-v", "--verbosity",        dest="verbosity",      action="store",      default=1,     type="int",    help="trace level [format: int]")
  parser.add_option("-l", "--log",              dest="log",            action="store",      default=None,  type="string", help="write a log file [format: bool] [default: false]")
  (options, args) = parser.parse_args()

  logHandle = None
  if options.log != None:
    logHandle = open(options.log, "w")
    
  transcriptContainer1 = TranscriptContainer(options.inputFileName1, options.format1, options.verbosity)
  transcriptContainer2 = TranscriptContainer(options.inputFileName2, options.format2, options.verbosity)
  
  transcriptListComparator = TranscriptListsComparator(logHandle, options.verbosity)
  transcriptListComparator.restrictToStart(transcriptListComparator.REFERENCE, 10)
  transcriptListComparator.getColinearOnly(True)
  transcriptListComparator.computeOddsPerTranscript(True)
  transcriptListComparator.setInputTranscriptContainer(transcriptListComparator.QUERY, transcriptContainer1)
  transcriptListComparator.setInputTranscriptContainer(transcriptListComparator.REFERENCE, transcriptContainer2)
  transcriptListComparator.compareTranscriptList()
  transcriptTables = transcriptListComparator.getOutputTables()
  
  sizesWithIntrons           = {}
  sizesWithoutIntrons        = {}
  nbExons                    = {}
  averageSizesWithIntrons    = {}
  averageSizesWithoutIntrons = {}
  averageNbExons             = {}
  sumSizesWithIntrons        = {}
  sumSizesWithoutIntrons     = {}
  sumSizesNbExons            = {}
  coverages                  = transcriptListComparator.getOddsPerTranscript()

  progress = Progress(transcriptContainer2.getNbTranscripts(), "Reading transcript file again", options.verbosity)
  for transcript in transcriptContainer2.getIterator():
    if transcript.name in coverages:
      if transcript.getSizeWithIntrons() not in averageSizesWithIntrons:
        averageSizesWithIntrons[transcript.getSizeWithIntrons()] = coverages[transcript.name]
      else:
        averageSizesWithIntrons[transcript.getSizeWithIntrons()] += coverages[transcript.name]
      if transcript.getSizeWithIntrons() not in sumSizesWithIntrons:
        sumSizesWithIntrons[transcript.getSizeWithIntrons()] = 1
      else:
        sumSizesWithIntrons[transcript.getSizeWithIntrons()] += 1
      if transcript.getSize() not in averageSizesWithoutIntrons:
        averageSizesWithoutIntrons[transcript.getSize()] = coverages[transcript.name]
      else:
        averageSizesWithoutIntrons[transcript.getSize()] += coverages[transcript.name]
      if transcript.getSize() not in sumSizesWithoutIntrons:
        sumSizesWithoutIntrons[transcript.getSize()] = 1
      else:
        sumSizesWithoutIntrons[transcript.getSize()] += 1
      if transcript.getNbExons() not in averageNbExons:
        averageNbExons[transcript.getNbExons()] = coverages[transcript.name]
      else:
        averageNbExons[transcript.getNbExons()] += coverages[transcript.name]
      if transcript.getNbExons() not in sumSizesNbExons:
        sumSizesNbExons[transcript.getNbExons()] = 1
      else:
        sumSizesNbExons[transcript.getNbExons()] += 1
      sizesWithIntrons[transcript.name]    = (transcript.getSizeWithIntrons(), coverages[transcript.name])
      sizesWithoutIntrons[transcript.name] = (transcript.getSize(), coverages[transcript.name])
      nbExons[transcript.name]             = (transcript.getNbExons(), coverages[transcript.name])
    progress.inc()
  progress.done()
    
  plotterSizeWithIntrons = RPlotter("%sWithIntrons.png" % (options.output), options.verbosity)
  plotterSizeWithIntrons.setPoints(True)
  plotterSizeWithIntrons.setMaximumX(10000)
  plotterSizeWithIntrons.setMaximumY(1000)  
  plotterSizeWithIntrons.setLog("y")
  plotterSizeWithIntrons.addLine(sizesWithIntrons)
  plotterSizeWithIntrons.plot()
  
  plotterSizeWithoutIntrons = RPlotter("%sWithoutIntrons.png" % (options.output), options.verbosity)
  plotterSizeWithoutIntrons.setPoints(True)
  plotterSizeWithoutIntrons.setMaximumX(10000)  
  plotterSizeWithoutIntrons.setMaximumY(1000)
  plotterSizeWithoutIntrons.setLog("y")
  plotterSizeWithoutIntrons.addLine(sizesWithoutIntrons)
  plotterSizeWithoutIntrons.plot()
  
  plotterNbExons = RPlotter("%sNbExons.png" % (options.output), options.verbosity)
  plotterNbExons.setPoints(True)
  plotterNbExons.addLine(nbExons)
  plotterNbExons.plot()
  
  for element in averageSizesWithIntrons:
    averageSizesWithIntrons[element] = int(float(averageSizesWithIntrons[element]) / sumSizesWithIntrons[element])
  plotterAverageSizeWithIntrons = RPlotter("%sAverageWithIntrons.png" % (options.output), options.verbosity)
  plotterAverageSizeWithIntrons.setMaximumX(10000)
  plotterAverageSizeWithIntrons.setMaximumY(1000)  
  plotterAverageSizeWithIntrons.setLog("y")
  plotterAverageSizeWithIntrons.addLine(averageSizesWithIntrons)
  plotterAverageSizeWithIntrons.plot()
  print "min/avg/med/max sizes with introns: %d/%.2f/%.1f/%d" % utils.getMinAvgMedMax(averageSizesWithIntrons)

  for element in averageSizesWithoutIntrons:
    averageSizesWithoutIntrons[element] = int(float(averageSizesWithoutIntrons[element]) / sumSizesWithoutIntrons[element])
  plotterAverageSizeWithoutIntrons = RPlotter("%sAverageWithoutIntrons.png" % (options.output), options.verbosity)
  plotterAverageSizeWithoutIntrons.setMaximumX(10000)
  plotterAverageSizeWithoutIntrons.setMaximumY(1000)  
  plotterAverageSizeWithoutIntrons.setLog("y")
  plotterAverageSizeWithoutIntrons.addLine(averageSizesWithoutIntrons)
  plotterAverageSizeWithoutIntrons.plot()
  print "min/avg/med/max sizes without introns: %d/%.2f/%.1f/%d" % utils.getMinAvgMedMax(averageSizesWithoutIntrons)

  for element in averageNbExons:
    averageNbExons[element] = int(float(averageNbExons[element]) / sumSizesNbExons[element])
  plotterAverageNbExons = RPlotter("%sAverageNbExons.png" % (options.output), options.verbosity)
  plotterAverageNbExons.addLine(averageNbExons)
  plotterAverageNbExons.plot()
  print "min/avg/med/max # exons: %d/%.2f/%.1f/%d" % utils.getMinAvgMedMax(averageNbExons)

  if options.log:
    logHandle.close()
