from structure.transcript import *
from structure.transcriptList import *
from writer.transcriptListWriter import *


class Gff3Writer(TranscriptListWriter):
  """
  A class that writes a transcript list into a file with GFF3 format
  @ivar fileName: name of the file 
  @type fileName: string
  @ivar handle: handle to the file
  @type handle: file handle
  """


  def __init__(self, fileName, verbosity = 0):
    """
    Constructor
    @param fileName: name of the file 
    @type fileName: string
    @param verbosity: verbosity
    @type verbosity: int
    """
    self.header = ""
    self.title  = "S-MART"
    super(Gff3Writer, self).__init__(fileName, verbosity)
      

  def setTitle(self, title):
    """
    Set the title of the transcripts
    @param title: the title of the transcripts
    @type  title: string
    """
    self.title = title


  def printTranscript(self, transcript):
    """
    Export the given transcript with GFF2 format
    @param transcript: transcript to be printed
    @type transcript: class L{Transcript<Transcript>}
    @return: a string
    """
    return transcript.printGff3(self.title)

