#! /usr/bin/env python
"""Modify the content of a FASTA file"""

from optparse import OptionParser
from parsing.sequenceListParser import *
from writer.fastaWriter import *
from misc.progress import *


if __name__ == "__main__":
  
  # parse command line
  description = "Modify Sequence List: Extend or shring a list of sequences. [Category: Data Modification]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",           dest="inputFileName",  action="store",                     type="string", help="input file [compulsory] [format: file in FASTA format]")
  parser.add_option("-o", "--output",          dest="outputFileName", action="store",      default=None,  type="string", help="output file [compulsory] [format: output file in FASTA format]")
  parser.add_option("-s", "--start",           dest="start",          action="store",      default=None,  type="int",    help="keep first nucleotides [format: int]")
  parser.add_option("-e", "--end",             dest="end",            action="store",      default=None,  type="int",    help="keep last nucleotides [format: int]")
  parser.add_option("-v", "--verbosity",       dest="verbosity",      action="store",      default=1,     type="int",    help="trace level [format: int]")
  (options, args) = parser.parse_args()

  parser   = SequenceListParser(options.inputFileName, options.verbosity)
  writer   = FastaWriter(options.outputFileName, options.verbosity)
  progress = Progress(parser.getNbSequences(), "Reading file %s" % (options.inputFileName), options.verbosity)
  for sequence in parser.getIterator():
    if options.start != None:
      sequence.shrinkToFirstNucleotides(options.start)
    if options.end != None:
      sequence.shrinkToLastNucleotides(options.end)
    writer.addSequence(sequence)
    progress.inc()
  progress.done()
