import os, sys, glob
from parsing.transcriptListParser import *
from parsing.mapperParser import *
from parsing.sequenceListParser import *
from parsing.gffParser import *
from parsing.mapperParser import *
from parsing.nucmerParser import *
from parsing.seqmapParser import *
from parsing.soapParser import *
from parsing.blastParser import *
from parsing.pslParser import *
from parsing.rmapParser import *
from parsing.shrimpParser import *
from parsing.axtParser import *
from parsing.exoParser import *
from parsing.maqParser import *
from parsing.samParser import *

 
class ParserChooser(object):
  """
  A class that finds the correct parser
  @ivar format:    the format
  @type format:    string
  @ivar type:      transcript / mapping / sequence parser
  @type type:      string
  @ivar parser:    the parser
  @type parser:    object
  @ivar verbosity: verbosity
  @type verbosity: int    
  """

  def __init__(self, verbosity = 0):
    """
    Constructor
    @param verbosity: verbosity
    @type  verbosity: int
    """
    self.type        = None
    self.parserClass = None
    self.verbosity   = verbosity
  
  def findFormat(self, format, type = None):
    """
    Find the correct parser
    @ivar format: the format
    @type format: string
    @ivar type:   transcript / mapping / sequence parser (None is all)
    @type type:   string
    @return:      a parser
    """
    classes = {}
    if (type == "transcript"):
      classes = {TranscriptListParser: "transcript"}
    elif (type == "mapping"):
      classes = {MapperParser: "mapping"}
    elif (type == "sequence"):
      classes = {SequenceListParser: "sequence"}
    elif (type == None):
      classes = {TranscriptListParser: "transcript", MapperParser: "mapping", SequenceListParser: "sequence"}
    else:
      sys.exit("Do not understand format type '%s'" % (type))

    for classType in classes:
      for parserClass in classType.__subclasses__():
        if format in parserClass.getFileFormats():
          self.parserClass = parserClass
          self.type        = classes[classType]
          return
    sys.exit("Cannot get parser for format '%s'" % (format))


  def getParser(self, fileName):
    """
    Get the parser previously found
    @return: the parser
    """
    return self.parserClass(fileName, self.verbosity)


  def getType(self):
    """
    Get the type of parser previously found
    @return: the type of parser
    """
    return self.type
