import unittest
from writer.gff3Writer import *


class TestGff3Writer(unittest.TestCase):
  
  def setUp(self):
    pass   

  def tearDown(self):
    pass


  def testWriter(self):
    fileName = "TestFiles/testGffWriter1.gff3"
    writer   = Gff3Writer("TestFiles/testGffWriter1.gff3")

    transcript = Transcript()
    transcript.setName("test1.1")
    transcript.setChromosome("arm_X")
    transcript.setStart(1000)
    transcript.setEnd(4000)
    transcript.setDirection("+")
    transcript.setTagValue("ID", "test1.1-1")
    transcript.setTagValue("occurrence", 1)
    transcript.setTagValue("nbOccurrences", 2)

    exon1 = Interval()
    exon1.setChromosome("arm_X")
    exon1.setStart(1000)
    exon1.setEnd(2000)
    exon1.setDirection("+")

    exon2 = Interval()
    exon2.setChromosome("arm_X")
    exon2.setStart(3000)
    exon2.setEnd(4000)
    exon2.setDirection("+")

    transcript.addExon(exon1)
    transcript.addExon(exon2)

    writer.addTranscript(transcript)
    writer.write()
    writer.__del__()

    expectedOutput = \
"""arm_X	S-MART	S-MART_transcript	1000	4000	3001	+	.	Name=test1.1;nbOccurrences=2;ID=test1.1-1;occurrence=1
arm_X	S-MART	S-MART_exon	1000	2000	1001	+	.	ID=test1.1-1-exon1;Name=test1.1-exon1;Parent=test1.1-1
arm_X	S-MART	S-MART_exon	3000	4000	1001	+	.	ID=test1.1-1-exon2;Name=test1.1-exon2;Parent=test1.1-1
"""

    file           = open(fileName)
    print fileName
    observedOutput = file.read()
    file.close()
    self.assertEqual(expectedOutput, observedOutput)

    os.remove(fileName)


if __name__ == '__main__':
    unittest.main()


