#!/usr/bin/env python

import os
import sys
import time
import shutil
from commons.core.checker.RepetException import RepetException
try:
	newDir = None
	print os.uname()
	beginTime = time.time()
	print 'beginTime=%f' % beginTime
	print "work in dir '@@tmpDir@@'"
	sys.stdout.flush()
	if not os.path.exists( "@@tmpDir@@" ):
		raise IOError("ERROR: temporary directory '@@tmpDir@@' doesn't exist")
	
	minFreeGigaInTmpDir = 1
	freeSpace = os.statvfs("@@tmpDir@@")
	if ((freeSpace.f_bavail * freeSpace.f_frsize) / 1073741824.0 < minFreeGigaInTmpDir):
		raise RepetException("ERROR: less than %iG of free space in '@@tmpDir@@'" % minFreeGigaInTmpDir)
	
	os.chdir("@@tmpDir@@")
	newDir = "@@groupId@@_@@jobName@@_@@time@@"
	if os.path.exists(newDir):
		shutil.rmtree(newDir)
	os.mkdir(newDir)
	os.chdir(newDir)
	
	@@cmdStart@@
	if log != 0:
		raise RepetException("ERROR: job returned %i" % log)
	else:
		print "job finished successfully"
	sys.stdout.flush()
	@@cmdFinish@@
	
	os.chdir("..")
	shutil.rmtree(newDir)	
	endTime = time.time()
	print 'endTime=%f' % endTime
	print 'executionTime=%f' % (endTime - beginTime)
	print os.uname()
	sys.stdout.flush()

except IOError, e :
	print e
	sys.stdout.flush()
	sys.exit(1)