import unittest
from commons.core.utils.FileUtils import FileUtils
import os
from commons.core.parsing.PalsToAlign import PalsToAlign

class Test_PalsToAlign(unittest.TestCase):
    
    def setUp(self):
        self._palsFileName = "input.gff"
        self._expAlignFileName = "file.align"
        self._obsAlignFileName = "output.align"
        
    def tearDown(self):
        os.remove(self._palsFileName)
        os.remove(self._expAlignFileName)
        os.remove(self._obsAlignFileName)

    def testRun(self):
        self._writePalsFile(self._palsFileName)
        self._writeExpAlignFile(self._expAlignFileName)
        
        iPalsToAlign = PalsToAlign(self._palsFileName,self._obsAlignFileName)
        iPalsToAlign.run()
        
        self.assertTrue(FileUtils.are2FilesIdentical(self._expAlignFileName, self._obsAlignFileName))


    def _writePalsFile(self, fileName):
        f = open(fileName, "w")
        f.write("chunk01\tpals\thit\t32290\t32583\t252\t+\t.\tTarget chunk02 28975 29268; maxe 0.035\n")
        f.write("chunk01\tpals\thit\t28975\t29268\t252\t+\t.\tTarget chunk02 32290 32583; maxe 0.035\n") 
        f.write("chunk01\tpals\thit\t65932\t66032\t68\t+\t.\tTarget chunk02 59293 59395; maxe 0.085\n")
        f.close()
        
    def _writeExpAlignFile(self, fileName):
        f = open(fileName, "w")
        f.write("chunk01\t28975\t29268\tchunk02\t32290\t32583\t0.0\t252\t96.5\n") 
        f.write("chunk01\t32290\t32583\tchunk02\t28975\t29268\t0.0\t252\t96.5\n")
        f.write("chunk01\t65932\t66032\tchunk02\t59293\t59395\t0.0\t68\t91.5\n")
        f.close()

if __name__ == "__main__":
    unittest.main()