import unittest
import os
from commons.core.parsing.PilerTAToGrouperMap import PilerTAToGrouperMap
from commons.core.utils.FileUtils import FileUtils

class Test_pilerTAToGrouperMap(unittest.TestCase):

    def setUp(self):
        self._inputGffFileName = "input.gff"
        self._inputPYRFileName = "input_pyr.gff"
        self._inputMOTIFFileName = "input_motif.gff"
        
        self._obsOutFileName = "output.info"
        self._obsGrouperFileName = "input_motif.gff.grp"
        self._obsGrpMapFileName = "input_motif.gff.grp.map"
        
        self._expOutFileName = "exp_output.info"
        self._expGrouperFileName = "exp_motif.gff.grp"
        self._expGrpMapFileName = "exp_motif.gff.grp.map"
        
    def tearDown(self):
        os.remove(self._inputGffFileName)
        os.remove(self._inputPYRFileName)
        os.remove(self._inputMOTIFFileName)
        
        os.remove(self._obsOutFileName)
        os.remove(self._obsGrouperFileName)
        os.remove(self._obsGrpMapFileName)
        
        os.remove(self._expOutFileName)
        os.remove(self._expGrouperFileName)
        os.remove(self._expGrpMapFileName)

    def testRun(self):
        self._writePilerTAFilePYR(self._inputPYRFileName)
        self._writePilerTAFileMOTIF(self._inputMOTIFFileName)
        self._writePilerTAGff(self._inputGffFileName)
        
        self._writeExpOutputFile(self._expOutFileName)
        self._writeExpGrouperFile(self._expGrouperFileName)
        self._writeExpGrouperMapFile(self._expGrpMapFileName)
        
        iPilerTAToGrouperMap = PilerTAToGrouperMap(self._inputGffFileName, self._inputPYRFileName,self._inputMOTIFFileName, self._obsOutFileName)
        iPilerTAToGrouperMap.run()
        
        self.assertTrue(FileUtils.are2FilesIdentical(self._expOutFileName, self._obsOutFileName))
        self.assertTrue(FileUtils.are2FilesIdentical(self._expGrouperFileName, self._obsGrouperFileName))
        self.assertTrue(FileUtils.are2FilesIdentical(self._expGrpMapFileName, self._obsGrpMapFileName))


    def _writePilerTAGff(self, fileName):
        f = open(fileName, "w")
        f.write("chunk21\tpiler\thit\t155146\t156020\t0\t+\t.\tTarget chunk21 150519 151392 ; Pile 510 ; Pyramid 0\n")
        f.write("chunk21\tpiler\thit\t154790\t156023\t0\t+\t.\tTarget chunk21 150519 151751 ; Pile 510 ; Pyramid 0\n")
        f.write("chunk21\tpiler\thit\t154078\t156023\t0\t+\t.\tTarget chunk21 150519 152463 ; Pile 510 ; Pyramid 0\n")
        f.write("chunk21\tpiler\thit\t154256\t156023\t0\t+\t.\tTarget chunk21 150519 152285 ; Pile 510 ; Pyramid 0\n")
        f.write("chunk21\tpiler\thit\t154434\t156023\t0\t+\t.\tTarget chunk21 150519 152107 ; Pile 510 ; Pyramid 0\n")
        f.close()

    def _writePilerTAFilePYR(self, fileName):
        f = open(fileName, "w")
        f.write("chunk21\tpiler\tpyramid\t150519\t156023\t0\t.\t.\tPyramidIndex 0\n")
        f.write("chunk21\tpiler\tpyramid\t150519\t156023\t0\t.\t.\tPyramidIndex 1\n")
        f.write("chunk21\tpiler\tpyramid\t165574\t174424\t0\t.\t.\tPyramidIndex 2\n")
        f.write("chunk21\tpiler\tpyramid\t166301\t174424\t0\t.\t.\tPyramidIndex 3\n")
        f.write("chunk21\tpiler\tpyramid\t168967\t174424\t0\t.\t.\tPyramidIndex 4\n")
        f.write("chunk21\tpiler\tpyramid\t170215\t174424\t0\t.\t.\tPyramidIndex 5\n")
        f.close()
        
    def _writePilerTAFileMOTIF(self, fileName):
        f = open(fileName, "w")
        f.write("chunk21\tpiler\ttandemmotif\t155843\t156020\t0\t.\t.\tTarget chunk21 151215 151392 ; Pyramid 0\n")
        f.write("chunk21\tpiler\ttandemmotif\t151215\t151392\t0\t.\t.\tTarget chunk21 155843 156020 ; Pyramid 0\n")
        f.write("chunk21\tpiler\ttandemmotif\t151574\t151751\t0\t.\t.\tTarget chunk21 155843 156020 ; Pyramid 0\n")
        f.write("chunk21\tpiler\ttandemmotif\t152286\t152463\t0\t.\t.\tTarget chunk21 155843 156020 ; Pyramid 0\n")
        f.write("chunk21\tpiler\ttandemmotif\t152108\t152285\t0\t.\t.\tTarget chunk21 155843 156020 ; Pyramid 0\n")
        f.close()
        
    def _writeExpOutputFile(self, fileName):
        f = open(fileName, "w")
        f.write("Pile 510\tPyramid 0\n")
        f.write("\tPyramid 1\n")
        f.write("\tPyramid 2\n")
        f.write("\tPyramid 3\n")
        f.write("\tPyramid 4\n")
        f.write("\tPyramid 5\n")
        f.close()
    
    def _writeExpGrouperFile(self, fileName):
        f = open(fileName, "w")
        f.write("MbS1Gr0Cl510\tchunk21\tpiler\ttandemmotif\t155843\t156020\t0\t.\t.\tTarget chunk21 151215 151392 \tPile 510\tPyramid 0\n")
        f.write("MbS2Gr0Cl510\tchunk21\tpiler\ttandemmotif\t151215\t151392\t0\t.\t.\tTarget chunk21 155843 156020 \tPile 510\tPyramid 0\n")
        f.write("MbS3Gr0Cl510\tchunk21\tpiler\ttandemmotif\t151574\t151751\t0\t.\t.\tTarget chunk21 155843 156020 \tPile 510\tPyramid 0\n")
        f.write("MbS4Gr0Cl510\tchunk21\tpiler\ttandemmotif\t152286\t152463\t0\t.\t.\tTarget chunk21 155843 156020 \tPile 510\tPyramid 0\n")
        f.write("MbS5Gr0Cl510\tchunk21\tpiler\ttandemmotif\t152108\t152285\t0\t.\t.\tTarget chunk21 155843 156020 \tPile 510\tPyramid 0\n")
        f.close()
        
    def _writeExpGrouperMapFile(self, fileName):
        f = open(fileName, "w")
        f.write("MbS1Gr0Cl510\tchunk21\t155843\t156020\n") 
        f.write("MbS2Gr0Cl510\tchunk21\t151215\t151392\n") 
        f.write("MbS3Gr0Cl510\tchunk21\t151574\t151751\n") 
        f.write("MbS4Gr0Cl510\tchunk21\t152286\t152463\n") 
        f.write("MbS5Gr0Cl510\tchunk21\t152108\t152285\n") 
        f.close()
        
if __name__ == "__main__":
    unittest.main()