#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
import sys
from optparse import OptionParser
from commons.core.parsing.SequenceListParser import SequenceListParser
from SMART.Java.Python.misc.Progress import Progress

"""
Transform qual and fasta files to a single fastq file
"""

if __name__ == "__main__":
    
    # parse command line
    description = "Qual To FastQ v1.0.2: Convert a file in FASTA/Qual format to FastQ format. [Category: Conversion]"

    parser = OptionParser(description = description)
    parser.add_option("-f", "--fasta",     dest="fastaFileName",  action="store",               type="string", help="input fasta file [compulsory] [format: file in FASTA format]")
    parser.add_option("-q", "--qual",      dest="qualFileName",   action="store",               type="string", help="input qual file [compulsory] [format: file in TXT format]")
    parser.add_option("-o", "--output",    dest="outputFileName", action="store", default=None, type="string", help="output file [compulsory] [format: output file in FASTQ format]")
    parser.add_option("-v", "--verbosity", dest="verbosity",      action="store", default=1,    type="int",    help="trace level [format: int]")
    (options, args) = parser.parse_args()
    
    fastaFile = open(options.fastaFileName)
    qualFile  = open(options.qualFileName)
    fastqFile = open(options.outputFileName, "w")
    
    fastaLine = fastaFile.readline().strip()
    qualLine  = qualFile.readline().strip()
    header    = None
    cpt       = 0
    while fastaLine:
        if not qualLine:
            raise Exception("Qual file is shorter!")
        if fastaLine[0] == ">":
            header = fastaLine[1:]
            if qualLine[0] != ">":
                raise Exception("Discrepencies around %s!" % (header))
            fastqFile.write("@%s\n" % (header))
        else:
            if qualLine[0] == ">":
                raise Exception("Discrepencies around %s!" % (qualLine[1:]))
            intQualities = qualLine.split()
            if len(intQualities) != len(fastaLine):
                raise Exception("Sizes of read and quality diverge in %s!" % (header))
            chrQualities = [chr(min(int(quality), 93) + 33) for quality in intQualities]
            fastqFile.write("%s\n+\n%s\n" % (fastaLine, "".join(chrQualities)))
        fastaLine = fastaFile.readline().strip()
        qualLine  = qualFile.readline().strip()
        if cpt % 1000 == 0 and options.verbosity > 1:
            sys.stdout.write("%d lines read\r" % (cpt))
            sys.stdout.flush()
        cpt += 1
    if options.verbosity > 0:
        print "%d lines read" % (cpt)
        
    if qualLine:
        raise Exception("Qual file is longer!")

