#! /usr/bin/env python
"""Convert a list of coordinates to sequences"""

import os
from optparse import OptionParser
from parsing.sequenceListParser import *
from structure.transcriptContainer import *
from writer.fastaWriter import *
from misc.progress import *


if __name__ == "__main__":
  
  # parse command line
  description = "Coordinates to Sequences: Extract the sequences from a list of coordinates. [Category: Conversion]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",           dest="inputFileName",  action="store",                     type="string", help="input file [compulsory] [format: file in transcript format given by -f]")
  parser.add_option("-f", "--format",          dest="format",         action="store",                     type="string", help="format of file [compulsory] [format: transcript file format]")
  parser.add_option("-s", "--sequences",       dest="sequences",      action="store",                     type="string", help="file that contains the sequences [compulsory] [format: file in TXT format]")
  parser.add_option("-o", "--output",          dest="outputFileName", action="store",      default=None,  type="string", help="output file (FASTA format) [format: output file in FASTA format]")
  parser.add_option("-v", "--verbosity",       dest="verbosity",      action="store",      default=1,     type="int",    help="trace level [format: int]")
  parser.add_option("-l", "--log",             dest="log",            action="store",      default=None,  type="string", help="write a log file [format: bool]")
  (options, args) = parser.parse_args()

  logHandle = None
  if options.log != None:
    logHandle = open(options.log, "w")
 
  # create parser
  parser = TranscriptContainer(options.inputFileName, options.format, options.verbosity) 

  sequenceParser = SequenceListParser(options.sequences, options.verbosity)

  writer   = FastaWriter(options.outputFileName, options.verbosity)
  progress = Progress(parser.getNbTranscripts(), "Reading %s" % (options.inputFileName), options.verbosity)
  for transcript in parser.getIterator():
    sequence = transcript.extractSequence(sequenceParser)
    writer.addSequence(sequence)
    progress.inc()
  progress.done()

  if options.log:
    logHandle.close()
