#! /usr/bin/env python
"""Convert a pseudo-FASTQ file to QUAL files"""

import os
from optparse import OptionParser
from misc.progress import *
from math import *

if __name__ == "__main__":
  
  # parse command line
  description = "Wrong FastQ to Qual: Convert a pseudo-FastQ (i.e. a FastQ file with a wrong format) into a Qual file. [Category: Personnal]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",      dest="inputFileName",     action="store",                        type="string", help="input file [compulsory] [format: file in FASTQ format]")
  parser.add_option("-o", "--output",     dest="outputFileName",    action="store",                        type="string", help="output file [compulsory] [format: output file in QUAL format]")
  parser.add_option("-v", "--verbosity",  dest="verbosity",         action="store",      default=1,        type="int",    help="trace level [format: int] [default: 1]")
  (options, args) = parser.parse_args()

  inputFile       = open(options.inputFileName)
  outputFastaFile = open("%s.fasta" % (options.outputFileName), "w")
  outputQualFile  = open("%s.qual" % (options.outputFileName), "w")
  
  inSequence   = False
  inQuality    = True
  sequenceName = None
  for line in inputFile:
    line = line.strip()
    if line[0] == "@":
      if inQuality == False:
        sys.exit("Quality of %s is missing" % (sequenceName))
      inSequence   = True
      inQuality    = False
      sequenceName = line[1:]
      outputFastaFile.write(">%s\n" % (sequenceName))
    elif line[0] == "+":
      if inSequence == False:
        sys.exit("Sequence of %s is missing" % (line[1:]))
      inSequence   = False
      inQuality    = True
      if sequenceName != line[1:]:
        sys.exit("Names in sequence and qual are different (%s, %s)" % (sequenceName, line[1:]))
      outputQualFile.write(">%s\n" % (sequenceName))
    else:
      if inSequence:
        outputFastaFile.write("%s\n" % (line))
      elif inQuality:
        outputQualFile.write("%s\n" % (line))
  
  inputFile.close()
  outputFastaFile.close()
  outputQualFile.close()
