#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#


"""Convert files with some mapping format to coordinates format"""

import os
from optparse import OptionParser
from commons.core.parsing.PslParser import PslParser
from commons.core.parsing.AxtParser import AxtParser
from commons.core.writer.Gff3Writer import Gff3Writer
from commons.core.writer.MySqlTranscriptWriter import MySqlTranscriptWriter
from SMART.Java.Python.structure.TranscriptListsComparator import TranscriptListsComparator
from SMART.Java.Python.structure.TranscriptContainer import TranscriptContainer
from SMART.Java.Python.misc.Progress import Progress


class MappingToCoordinates(object):
    def __init__(self,verbosity=1, inputFileName=None, format = None, output=None,galaxy = False, title="S-MART"):
        self.verbosity = verbosity
        self.inputFileName = inputFileName
        self.format = format
        self.output = output
        self.galaxy = galaxy
        self.title = title
    
    def setAttributesFromCmdLine(self):
        description = "Mapping To Coordinates v1.0.1: Convert a set of mappings (given by a mapping tool) to a set of transcripts. [Category: Conversion]"
        parser = OptionParser(description = description)
        parser.add_option("-i", "--input",     dest="inputFileName", action="store",                     type="string", help="input file [compulsory] [format: file in mapping format given by -f]")
        parser.add_option("-f", "--format",    dest="format",        action="store",                     type="string", help="format of file [compulsory] [format: mapping file format]")
        parser.add_option("-o", "--output",    dest="output",        action="store",      default=None,  type="string", help="output file [compulsory] [format: output file in GFF3 format]")
        parser.add_option("-v", "--verbosity", dest="verbosity",     action="store",      default=1,     type="int",    help="trace level [format: int]")
        parser.add_option("-G", "--galaxy",    dest="galaxy",        action="store_true", default=False,                help="used for galaxy [format: bool] [default: False]")    
        (options, args) = parser.parse_args()
    
        self.verbosity = options.verbosity
        self.inputFileName = options.inputFileName
        self.format = options.format
        self.output = options.output
        self.galaxy = options.galaxy

    def run(self):  
        if self.verbosity > 0:
            print "Reading input file..."
        parser = TranscriptContainer(self.inputFileName, self.format, self.verbosity)
        if self.verbosity > 0:
            print "... done"
        writer = Gff3Writer(self.output, self.verbosity, self.title)
            
        progress = Progress(parser.getNbTranscripts(), "Reading %s" % (self.inputFileName), self.verbosity)
        for transcript in parser.getIterator():
            writer.addTranscript(transcript)
            progress.inc()
        progress.done()
        
        if self.galaxy:
            os.rename("%s.gff3" % (self.output), self.output) 
            
if __name__ == '__main__':
    launcher = MappingToCoordinates()
    launcher.setAttributesFromCmdLine()
    launcher.run()
