#! /usr/bin/env python
from optparse import OptionParser
import tarfile
import os
import re
import shutil
import subprocess

SMART_PATH = "%s/SMART" % os.environ["REPET_PATH"]

def toTar(tarFileName, directory):
    fileName = os.path.splitext(tarFileName)[0]
    fileNameBaseName = os.path.basename(fileName)
    tfile = tarfile.open(fileName + ".tmp.tar", "w")
    list = os.listdir(directory)
    for file in list:
        if re.search(str(fileNameBaseName), file):
            tfile.add(file)
    os.system("mv %s %s" % (fileName + ".tmp.tar", options.outTarFileName))
    tfile.close()



if __name__ == "__main__":
    
    # parse command line
    description = "Plot Coverage v1.0.1: Plot the coverage of the first data with respect to the second one. [Category: Visualization]"

    parser = OptionParser(description = description)
    parser.add_option("-i", "--input1",       dest="inputFileName1", action="store",                       type="string", help="input file 1 [compulsory] [format: file in transcript format given by -f]")
    parser.add_option("-f", "--inputFormat1", dest="inputFormat1",   action="store",                       type="string", help="format of input file 1 [compulsory] [format: transcript file format]")
    parser.add_option("-j", "--input2",       dest="inputFileName2", action="store",                       type="string", help="input file 2 [compulsory] [format: file in transcript format given by -g]")
    parser.add_option("-g", "--inputFormat2", dest="inputFormat2",   action="store",                       type="string", help="format of input file 2 [compulsory] [format: transcript file format]")
    parser.add_option("-q", "--sequence",     dest="inputSequence",  action="store",      default=None,    type="string", help="input sequence file [format: file in FASTA format] [default: None]")
    parser.add_option("-o", "--output",       dest="outTarFileName", action="store",                       type="string", help="output file [compulsory] [format: output file in zip format]")
    parser.add_option("-w", "--width",        dest="width",          action="store",      default=1500,    type="int",    help="width of the plots (in px) [format: int] [default: 1500]")
    parser.add_option("-e", "--height",       dest="height",         action="store",      default=1000,    type="int",    help="height of the plots (in px) [format: int] [default: 1000]")
    parser.add_option("-t", "--title",        dest="title",          action="store",      default="",      type="string", help="title of the plots [format: string]")
    parser.add_option("-x", "--xlab",         dest="xLabel",         action="store",      default="",      type="string", help="label on the x-axis [format: string]")
    parser.add_option("-y", "--ylab",         dest="yLabel",         action="store",      default="",      type="string", help="label on the y-axis [format: string]")
    parser.add_option("-p", "--plusColor",    dest="plusColor",      action="store",      default="red",   type="string", help="color for the elements on the plus strand [format: string] [default: red]")
    parser.add_option("-m", "--minusColor",   dest="minusColor",     action="store",      default="blue",  type="string", help="color for the elements on the minus strand [format: string] [default: blue]")
    parser.add_option("-s", "--sumColor",     dest="sumColor",       action="store",      default="black", type="string", help="color for 2 strands coverage line [format: string] [default: black]")
    parser.add_option("-l", "--lineColor",    dest="lineColor",      action="store",      default="black", type="string", help="color for the lines [format: string] [default: black]")
    parser.add_option("-1", "--merge",        dest="merge",          action="store_true", default=False,                  help="merge the 2 plots in 1 [format: boolean] [default: false]")
    parser.add_option("-v", "--verbosity",    dest="verbosity",      action="store",      default=1,       type="int",    help="trace level [format: int]")
    (options, args) = parser.parse_args()

    absPath = os.getcwd()
    directory = "/tmp/wrappPlotCov"
    if not os.path.exists(directory):
        os.makedirs(directory)
    os.chdir(directory)
    if options.inputFileName1 != None and options.inputFormat1 != None and options.inputFileName2 != None and options.inputFormat2 != None and options.outTarFileName != None:
        outputFileName = os.path.splitext(os.path.basename(options.outTarFileName))[0]
        print 'outputfile is :', outputFileName
        cmd = "python %s/Java/Python/plotCoverage.py -i %s -f %s -j %s -g %s -o %s -D %s" % (SMART_PATH, options.inputFileName1, options.inputFormat1, options.inputFileName2, options.inputFormat2, outputFileName, directory)
    if options.inputSequence!= None:
        cmd += " -q %s" % options.inputSequence
    if options.width != None:
        cmd += " -w %s" % options.width
    if options.height != None:
        cmd += " -e %s" % options.height
    if options.title != None:
        cmd += " -t %s" % options.title
    if options.xLabel != None:
        cmd += " -x %s" % options.xLabel
    if options.yLabel != None:
        cmd += " -y %s" % options.yLabel
    if options.plusColor != None:
        cmd += " -p %s" % options.plusColor
    if options.minusColor != None:
        cmd += " -m %s" % options.minusColor
    if options.sumColor != None:
        cmd += " -s %s" % options.sumColor
    if options.lineColor != None:
        cmd += " -l %s" % options.lineColor
    if options.merge:
        cmd += " -1"
    status = subprocess.call(cmd, shell=True)
    if status != 0:
            raise Exception("Problem with the execution of command!")
    toTar(options.outTarFileName, directory)
    shutil.rmtree(directory)

 


        
