#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
import re
import sys
try:
	 import cPickle as pickle
except:
	 import pickle
from SMART.Java.Python.structure.Interval import Interval
from commons.core.parsing.TranscriptListParser import TranscriptListParser
from SMART.Java.Python.structure.Transcript import Transcript


class PklParser(TranscriptListParser):
	"""A class that parses the intern PKL file and create a transcript list"""
		
	def __init__(self, fileName, verbosity = 1):
		self.title = None
		super(PklParser, self).__init__(fileName, verbosity)
		self.handle		   = open(fileName, "rb")
		self.verbosity	   = verbosity
		self.initAddress   = 0
		self.address	   = self.initAddress
		self.over		   = False
		self.chromosome	= None

	def __del__(self):
		super(PklParser, self).__del__()

	def getFileFormats():
		return ["pkl"]
	getFileFormats = staticmethod(getFileFormats)


	def skipFirstLines(self):
		return


	def reset(self):
		self.handle.seek(0)
		self.initAddress = 0


	def setChromosome(self, chromosome):
		self.chromosome = chromosome
	

	def gotoAddress(self, address):
		self.handle.seek(address)
		self.address = address


	def getNextTranscript(self):
		self.address = self.handle.tell()
		try:
			transcript = pickle.load(self.handle)
			if self.chromosome != None and transcript.getChromosome() != self.chromosome:
				self.over = True
				return False
			return transcript
		except EOFError:
			self.over = True
			return False


	def getIterator(self):
		self.gotoAddress(self.initAddress)
		while True:
			transcript = self.getNextTranscript()
			if not transcript:
				self.over = True
				return
			yield transcript


	def setInitAddress(self, address):
		self.initAddress = address


	def getCurrentTranscriptAddress(self):
		return self.address


	def isOver(self):
		return self.over
