# Copyright INRA (Institut National de la Recherche Agronomique)
# http://www.inra.fr
# http://urgi.versailles.inra.fr
#
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software.  You can  use, 
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info". 
#
# As a counterpart to the access to the source code and  rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty  and the software's author,  the holder of the
# economic rights,  and the successive licensors  have only  limited
# liability. 
#
# In this respect, the user's attention is drawn to the risks associated
# with loading,  using,  modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean  that it is complicated to manipulate,  and  that  also
# therefore means  that it is reserved for developers  and  experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or 
# data to be ensured and,  more generally, to use and operate it in the 
# same conditions as regards security. 
#
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.

import sys

## this class can parse a Ssr results output file. SSR.pl is developped by S.Cartinhour. (5/2000)
#
class SsrParser(object):


    def __init__(self, BES_name='', BES_redundancy='', SSR_nbNucleotides='', SSR_Motif='', SSR_Motif_number='', SSR_start='', SSR_end='', BES_size=''):
        self._BesName = BES_name
        self._BesRedundancy = BES_redundancy
        self._SsrNbNucleotides = SSR_nbNucleotides
        self._SsrMotif = SSR_Motif
        self._SsrMotifNumber = SSR_Motif_number
        self._SsrStart = SSR_start
        self._SsrEnd = SSR_end
        self._BesSize = BES_size
        
    def __eq__(self, o):
        return self._BesName == o._BesName and self._BesRedundancy == o._BesRedundancy and self._SsrNbNucleotides == o._SsrNbNucleotides and self._SsrMotif == o._SsrMotif and self._SsrMotifNumber == o._SsrMotifNumber and self._SsrStart == o._SsrStart and self._SsrEnd == o._SsrEnd and self._BesSize == o._BesSize
        
    def setBesName(self, BES_Name):
        self._BesName = BES_Name
        
    def setBesRedundancy(self, BES_redundancy):
        self._BesRedundancy = BES_redundancy
        
    def setSsrNbNucleotides(self, SSR_nbNucleotides):
        self._SsrNbNucleotides = SSR_nbNucleotides
        
    def setSsrMotif(self, SSR_Motif):
        self._SsrMotif = SSR_Motif
        
    def setSsrMotifNumber(self, SSR_Motif_number):
        self._SsrMotifNumber = SSR_Motif_number
        
    def setSsrStart(self, SSR_start):
        self._SsrStart = SSR_start
        
    def setSsrEnd(self, SSR_end):
        self._SsrEnd = SSR_end
        
    def setBesSize(self, BES_size):
        self._BesSize = BES_size
        
    def getBesName(self):
        return self._BesName
        
    def getBesRedundancy(self):
        return self._BesRedundancy
        
    def getSsrNbNucleotides(self):
        return self._SsrNbNucleotides
        
    def getSsrMotif(self):
        return self._SsrMotif
        
    def getSsrMotifNumber(self):
        return self._SsrMotifNumber
        
    def getSsrStart(self):
        return self._SsrStart
        
    def getSsrEnd(self):
        return self._SsrEnd
        
    def getBesSize(self):
        return self._BesSize
    
    def setAttributes(self, lResults, iCurrentLineNumber):
        error = False
        
        if lResults[0] != '':
            self.setBesName(lResults[0])
        else:
            sys.stderr.write("WARNING: The field BES Name is empty in SSR results file in line %s\n" % iCurrentLineNumber)
            error = True
        
        if lResults[1] != '':
            self.setBesRedundancy(lResults[1])
        else:
            sys.stderr.write("WARNING: The field BES Redundancy is empty in SSR results file in line %s\n" % iCurrentLineNumber)
            error = True
        
        if lResults[2] != '':
            self.setSsrNbNucleotides(lResults[2])
        else:
            sys.stderr.write("WARNING: The field SSR Number Nucleotides is empty in SSR results file in line %s\n" % iCurrentLineNumber)
            error = True
    
        if lResults[3] != '':
            self.setSsrMotif(lResults[3])
        else:
            sys.stderr.write("WARNING: The field SSR Motif is empty in SSR results file in line %s\n" % iCurrentLineNumber)
            error = True
    
        if lResults[4] != '':
            self.setSsrMotifNumber(lResults[4])
        else:
            sys.stderr.write("WARNING: The field SSR Motif Number is empty in SSR results file in line %s\n" % iCurrentLineNumber)
            error = True
    
        if lResults[5] != '':
            self.setSsrStart(lResults[5])
        else:
            sys.stderr.write("WARNING: The field SSR Start is empty in SSR results file in line %s\n" % iCurrentLineNumber)
            error = True
    
        if lResults[6] != '':
            self.setSsrEnd(lResults[6])
        else:
            sys.stderr.write("WARNING: The field SSR End is empty in SSR results file in line %s\n" % iCurrentLineNumber)
            error = True
    
        if lResults[7] != '':
            self.setBesSize(lResults[7])
        else:
            sys.stderr.write("WARNING: The field BES Size is empty in SSR results file in line %s\n" % iCurrentLineNumber)
            error = True
            
        if error == True:
            self._setAllToNull()
            
    def setAttributesFromString(self, ssrLine, iCurrentLineNumber ="", fieldSeparator ="\t"):
        ssrLine = ssrLine.rstrip()
        lSsrLineItem = ssrLine.split(fieldSeparator)
        if len(lSsrLineItem) < 8:
            sys.stderr.write("WARNING: The line %s is not a valid SSR Result line\n" % iCurrentLineNumber)
        else:
            self.setAttributes(lSsrLineItem, iCurrentLineNumber)
            
    def _setAllToNull(self):
        self._BesName = ''
        self._BesRedundancy = ''
        self._SsrNbNucleotides = ''
        self._SsrMotif = ''
        self._SsrMotifNumber = ''
        self._SsrStart = ''
        self._SsrEnd = ''
        self._BesSize = ''
    