# Copyright INRA (Institut National de la Recherche Agronomique)
# http://www.inra.fr
# http://urgi.versailles.inra.fr
#
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software.  You can  use, 
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info". 
#
# As a counterpart to the access to the source code and  rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty  and the software's author,  the holder of the
# economic rights,  and the successive licensors  have only  limited
# liability. 
#
# In this respect, the user's attention is drawn to the risks associated
# with loading,  using,  modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean  that it is complicated to manipulate,  and  that  also
# therefore means  that it is reserved for developers  and  experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or 
# data to be ensured and,  more generally, to use and operate it in the 
# same conditions as regards security. 
#
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.


from commons.core.parsing.VarscanHitForGnpSNP import VarscanHitForGnpSNP
from commons.core.parsing.VarscanFile import VarscanFile

class VarscanFileForGnpSNP(VarscanFile):
    
    def __init__(self, varscanFileName, fastqFileName="", refFastaFileName="", taxonName=""):
        VarscanFile.__init__(self, varscanFileName)
        self._fastqFileName = fastqFileName
        self._refFastaFileName = refFastaFileName
        self._taxonName = taxonName
        self._previousVarscanHit = None
        
    ## Equal operator
    #
    # @param o a VarscanFileAnalysis instance
    #    
    def __eq__(self, o):
        return VarscanFile.__eq__(self, o) and self._fastqFileName == o._fastqFileName \
            and self._refFastaFileName == o._refFastaFileName and self._taxonName == o._taxonName
             
    def getVarscanFieldSeparator(self):
        return self._varscanFieldSeparator
        
    def getFastqFileName(self):
        return self._fastqFileName
    
    def getRefFastaFileName(self):
        return self._refFastaFileName
    
    def getTaxonName(self):
        return self._taxonName
        
    def createVarscanHit(self, line, currentLineNumber):
        line = line.strip()
        lResults = line.split(self._varscanFieldSeparator)
        iVarscanHit = VarscanHitForGnpSNP()
        iVarscanHit.setAttributes(lResults, currentLineNumber)
        iVarscanHit.formatAlleles2GnpSnp()
        iVarscanHit.manageOccurrence(self._previousVarscanHit)
        self._previousVarscanHit = iVarscanHit
        return iVarscanHit
