import unittest
import os
from commons.core.utils.FileUtils import FileUtils
from SMART.Java.Python.getWigDistance import *

class Test_F_getWigDistance(unittest.TestCase):


    def setUp(self):
        self._inputGffFileName = 'inputGff.gff3'
        self._writeInputGff(self._inputGffFileName)
        self._inputWigFileName = '../TestFiles/sorted_query_wig.wig'
        self._outFileName = 'outGffWig.png'

    def tearDown(self):
        os.remove(self._inputGffFileName)
        os.remove(self._outFileName)        

    def test_getWigDistance_defaultOption(self):
        cmd = 'python ../getWigDistance.py -i %s -f gff3 -w %s -d 10 -o %s' % (self._inputGffFileName, self._inputWigFileName, self._outFileName)
        os.system(cmd)

    def test_getWigDistance_strandsOption(self):
        cmd = 'python ../getWigDistance.py -i %s -f gff3 -w %s -d 10 -o %s -s' % (self._inputGffFileName, self._inputWigFileName, self._outFileName)
        os.system(cmd)      
          
    def test_getWigDistance_logOption(self):
        cmd = 'python ../getWigDistance.py -i %s -f gff3 -w %s -d 10 -o %s -l' % (self._inputGffFileName, self._inputWigFileName, self._outFileName)
        os.system(cmd)
    
    def _writeInputGff(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest1.1\t25\t150\t126\t+\t.\tID=query_1;Name=test1.1\n")
        f.write("chr1\tquery\ttest1.2\t70\t850\t781\t-\t.\tID=query_2;Name=test1.2\n")
        f.write("chr1\tquery\ttest1.3\t550\t850\t201\t-\t.\tID=query_3;Name=test1.3\n")
        f.write("chr1\tquery\ttest1.4\t925\t1025\t101\t+\t.\tID=query_4;Name=test1.4\n")
        f.write("chr1\tquery\ttest1.5\t1201\t1210\t10\t+\t.\tID=query_5;Name=test1.5\n")
        f.write("chr1\tquery\ttest1.6\t1500\t1600\t101\t+\t.\tID=query_6;Name=test1.6\n")
        f.close()



if __name__ == "__main__":
    #import sys;sys.argv = ['', 'Test.testName']
    unittest.main()