import re
import sys
from optparse import OptionParser
from parsing.sequenceListParser import *
from misc.progress import *

"""
Transform qual and fasta files to a single fastq file
"""

if __name__ == "__main__":
  
  # parse command line
  description = "Qual To FastQ: Convert a file in Qual format to FastQ format. [Category: Conversion]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",           dest="inputFileName",  action="store",                      type="string", help="input file [compulsory] [format: file in QUAL format]")
  parser.add_option("-o", "--output",          dest="outputFileName", action="store",      default=None,   type="string", help="output file [compulsory] [format: output file in FASTQ format]")
  parser.add_option("-v", "--verbosity",       dest="verbosity",      action="store",      default=1,      type="int",    help="trace level [format: int]")
  (options, args) = parser.parse_args()
  
  print "Reading input file..."
  parser      = SequenceListParser("%s.fasta" % (options.inputFileName))
  nbSequences = parser.getNbSequences()
  print "... done"
  
  fastaFile = open("%s.fasta" % (options.inputFileName))
  qualFile  = open("%s.qual" % (options.inputFileName))
  fastqFile = open("%s.fastq" % (options.outputFileName), "w")
  
  fastaLine = fastaFile.readline().strip()
  qualLine  = qualFile.readline().strip()
  header    = None
  
  progress = Progress(nbSequences, "Reading input files %s" % (options.inputFileName), options.verbosity)
  while fastaLine:
    if not qualLine:
      sys.exit("Qual file is shorter!")
    if fastaLine[0] == ">":
      progress.inc()
      header = fastaLine[1:]
      if qualLine[0] != ">":
        sys.exit("Discrepencies around %s!" % (header))
      fastqFile.write("@%s\n" % (header))
    else:
      if qualLine[0] == ">":
        sys.exit("Discrepencies around %s!" % (qualLine[1:]))
      intQualities = qualLine.split()
      if len(intQualities) != len(fastaLine):
        sys.exit("Sizes of read and quality diverge in %s!" % (header))
      chrQualities = [chr(min(int(quality), 93) + 33) for quality in intQualities]
      fastqFile.write("%s\n+\n%s\n" % (fastaLine, "".join(chrQualities)))
    fastaLine = fastaFile.readline().strip()
    qualLine  = qualFile.readline().strip()
  progress.done()
    
  if qualLine:
    sys.exit("Qual file is longer!")
