#! /usr/bin/env python
"""Restrict a sequence list with some names"""

from optparse import OptionParser
from parsing.fastaParser import *
from writer.fastaWriter import *
from parsing.fastqParser import *
from writer.fastqWriter import *
from misc.progress import *


if __name__ == "__main__":
  
  # parse command line
  description = "Restrict Sequence List: Keep the elements of a list of sequences whose name is mentionned in a given file. [Category: Data Selection]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",      dest="inputFile",  action="store",                       type="string", help="input file [compulsory] [format: file in sequence format given by -f]")
  parser.add_option("-f", "--format",     dest="format",     action="store",      default="fasta", type="string", help="format of the input and output files [compulsory] [format: sequence file format] [default: fasta]")
  parser.add_option("-n", "--name",       dest="names",      action="store",                       type="string", help="names of the transcripts [compulsory] [format: file in TXT format]")
  parser.add_option("-o", "--output",     dest="outputFile", action="store",                       type="string", help="output file [format: output file in sequence format given by -f]")
  parser.add_option("-v", "--verbosity",  dest="verbosity",  action="store",      default=1,       type="int",    help="trace level [format: int]")
  parser.add_option("-l", "--log",        dest="log",        action="store_true", default=False,                  help="write a log file [format: bool] [default: false]")
  (options, args) = parser.parse_args()

  names     = []
  namesFile = open(options.names)
  for name in namesFile:
    names.append(name.strip())
  namesFile.close()

  if options.input == "fasta":
    parser = FastaParser(options.inputFile, options.verbosity)
    writer = FastaWriter(options.outputFile, options.verbosity)
  elif options.input == "fastq":
    parser = FastqParser(options.inputFile, options.verbosity)
    writer = FastqWriter(options.outputFile, options.verbosity)
  nbSequences = parser.getNbSequences()
  progress    = Progress(nbSequences, "Parsing file %s" % (options.inputFile), options.verbosity)
  for sequence in parser.getIterator():
    if sequence.name in names:
      writer.addSequence(sequence)
      names.remove(sequence.name)
    progress.inc()
  progress.done()
  
  if names:
    sys.exit("Some names are not present in the file: %s" % names)
