#! /usr/bin/env python
"""
Plot the data from the data files
"""

import os
import re
from optparse import OptionParser
from structure.transcriptContainer import *
from misc.rPlotter import *
from misc.progress import *


def mergeData(line1, line2):
  if line1.keys() != line2.keys():
    sys.exit("Error! Input files do not correspond to each other! Aborting...")
  mergedData = {}
  for key in line1:
    mergedData[key] = (line1[key], line2[key])
  return mergedData



if __name__ == "__main__":
  
  # parse command line
  description = "Plot Transcript Lists: Plot some information from transcript list using tags. [Category: Visualization]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",        dest="inputFileName",     action="store",                        type="string", help="input file [compulsory] [format: file in transcript format given by -f]")
  parser.add_option("-f", "--format",       dest="format",            action="store",                        type="string", help="format of the input [compulsory] [format: transcript file format]")
  parser.add_option("-x", "--x",            dest="x",                 action="store",                        type="string", help="tag for the x value [format: string]")
  parser.add_option("-y", "--y",            dest="y",                 action="store",                        type="string", help="tag for the y value [format: string]")
  parser.add_option("-z", "--z",            dest="z",                 action="store",      default=None,     type="string", help="tag for the z value [format: string]")
  parser.add_option("-X", "--xDefault",     dest="xDefault",          action="store",      default=None,     type="float",  help="value for x when tag is not present [format: float]")
  parser.add_option("-Y", "--yDefault",     dest="yDefault",          action="store",      default=None,     type="float",  help="value for y when tag is not present [format: float]")
  parser.add_option("-Z", "--zDefault",     dest="zDefault",          action="store",      default=None,     type="float",  help="value for z when tag is not present [format: float]")
  parser.add_option("-n", "--xLabel",       dest="xLabel",            action="store",      default="",       type="string", help="label on the x-axis [format: string] [default: ]")
  parser.add_option("-m", "--yLabel",       dest="yLabel",            action="store",      default="",       type="string", help="label on the y-axis [format: string] [default: ]")
  parser.add_option("-o", "--output",       dest="outputFileName",    action="store",                        type="string", help="output file names [format: output file in PNG format]")
  parser.add_option("-s", "--shape",        dest="shape",             action="store",                        type="string", help="shape of the plot [format: choice (line, points, heatPoints)]")
  parser.add_option("-l", "--log",          dest="log",               action="store",      default="",       type="string", help="use log on x- or y-axis (write 'x', 'y' or 'xy') [format: string] [default: ]")
  parser.add_option("-v", "--verbosity",    dest="verbosity",         action="store",      default=1,        type="int",    help="trace level [format: int]")
  (options, args) = parser.parse_args()

  plotter = RPlotter("%s.png" % (options.outputFileName), options.verbosity)
  if options.shape == "line":
    pass
  elif options.shape == "points":
    plotter.setPoints(True)
  elif options.shape == "heatPoints":
    plotter.setHeatPoints(True)
  else:
    sys.exit("Do not understand shape '%s'" % (options.shape))
    
  plotter.setLog(options.log)
  plotter.setXLabel(options.xLabel)
  plotter.setYLabel(options.yLabel)
  
  parser     = TranscriptContainer(options.inputFileName, options.format, options.verbosity)
  outputFile = open(options.outputFileName, "w")
  line       = {}
  heatLine   = {}

  for transcript in parser.getIterator():
    x = transcript.getTagValue(options.x)
    y = transcript.getTagValue(options.y)
    if options.z != None:
      z = transcript.getTagValue(options.z)
    if x == None:
      if options.xDefault != None:
        x = options.xDefault
      else:
        continue
    if y == None:
      if options.yDefault != None:
        y = options.yDefault
      else:
        continue
    if options.z != None:
      if z == None:
        if options.zDefault != None:
          z = options.zDefault
        else:
          continue

    x = float(x)
    y = float(y)
    if options.z != None:
      z = float(z)

    if options.shape == "points":
      line[transcript.name] = (x, y)
    elif options.shape == "heatPoints":
      line[transcript.name] = (x, y)
      heatLine[transcript.name] = z
    elif options.shape == "line":
      line[x] = y
    else:
      sys.exit("Do not understand shape '%s'" % (options.shape))


  if options.shape == "points":
    plotter.addLine(line)
  elif options.shape == "heatPoints":
    plotter.addLine(line)
    plotter.addHeatLine(heatLine)
  elif options.shape == "line":
    plotter.addLine(line)
  else:
    sys.exit("Do not understand shape '%s'" % (options.shape))

  plotter.plot()

  if options.shape == "points":
    print "Spearman rho: %f" % (plotter.getSpearmanRho())
        
