#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
"""
Test if the configuration is sound
"""

import sys
import os
import subprocess

# Test Python files
try :
    from SMART.Java.Python.misc.RPlotter import *
except:
    print "Cannot find Python scripts! Update PYTHONPATH (currently %s) environment variable and see configuration in the documentation!" % (os.environ["PYTHONPATH"] if "PYTHONPATH" in os.environ else "empty")
    sys.exit(3)

try :
    from SMART.Java.Python.mySql.MySqlTranscriptTable import *
    from SMART.Java.Python.mySql.MySqlConnection import *
except:
    print "SQLite is not installed ! Please read the documentation!"
    sys.exit(4)


if __name__ == "__main__":
    
    print "Python scripts are correctly read."
    
    # Test mySQL
    connection = MySqlConnection()
    table = MySqlTranscriptTable(connection)

    try:
        table.createTranscriptTable()
    except:
        print "Cannot connect to the SQLite database! See configuration in the documentation!"
        sys.exit(5)
        
    print "SQLite database is correctly set up."

        
    # Test R
    fileName = "tmpFile.R"
    file = open(fileName, "w")
    file.write("?licence\n")
    file.close()
    rCommand = "R"
    if "SMARTRPATH" in os.environ:
        rCommand = os.environ["SMARTRPATH"]
    command = "\"%s\" CMD BATCH %s" % (rCommand, fileName)
    status    = subprocess.call(command, shell=True)
    os.remove(fileName)
    outputFileName = "%sout" % (fileName)
    if os.path.exists(outputFileName):
        os.remove(outputFileName)

    if status != 0:
        print "Problem with the execution of R script (command '%s' did not work, current directory is %s, status is %d)! See configuration in the documentation!" % (command, os.getcwd(), status)
        sys.exit(6)

    line = {0: 1, 1: 2}
    pngFileName = "tmpFile.png"
    plotter = RPlotter(pngFileName)
    plotter.addLine(line)
    try:
        plotter.plot()
    except:
        print "Problem with the execution of R script: library 'RColorBrewer' is missing! See configuration in the documentation!"
        sys.exit(7)
    os.remove(pngFileName)

    print "R is available."

    print "Set up is fine! Enjoy S-MART!"
