from structure.sequence import *


class FastqWriter:
  """
  A class that writes a sequence list into a file with FASTQ format
  @ivar fileName: name of the file 
  @type fileName: string
  @ivar handle: handle to the file
  @type handle: file handle
  @ivar header: first lines of the file
  @type header: string
  """


  def __init__(self, fileName, verbosity = 0):
    """
    Constructor
    @param fileName: name of the file 
    @type fileName: string
    @param verbosity: verbosity
    @type verbosity: int
    """
    self.fileName       = fileName
    self.verbosity      = verbosity
    self.handle         = open(self.fileName, "w")
    

  def addSequence(self, sequence):
    """
    Add a transcript to the list of transcripts to be written
    @param sequence: sequence to be written
    @type  sequence: class L{Sequence<Sequence>}
    """
    self.handle.write(sequence.printFastq())


  def addElement(self, element):
    """
    Same as "addSequence"
    @param element: sequence to be written
    @type  element: class L{Sequence<Sequence>}
    """
    self.addSequence(element)
    
    
  def write(self):
    """
    No-op
    """
    pass
    
    
  def __del__(self):
    """
    Destructor
    """
    self.handle.close()
