#! /usr/bin/env python
"""
Merge two data files.
"""

import sys
import re
from optparse import OptionParser
from misc.progress import *


if __name__ == "__main__":
  
  # parse command line
  parser = OptionParser()
  parser.add_option("-i", "--input1",       dest="inputFileName1",    action="store",                        type="string", help="first input file")
  parser.add_option("-j", "--input2",       dest="inputFileName2",    action="store",                        type="string", help="second input file")
  parser.add_option("-o", "--output",       dest="outputFileName",    action="store",                        type="string", help="output file")
  parser.add_option("-v", "--verbosity",    dest="verbosity",         action="store",      default=1,        type="int",    help="trace level")
  parser.add_option("-l", "--log",          dest="log",               action="store_true", default=False,                   help="write a log file")
  (options, args) = parser.parse_args()

  inputFile1 = open(options.inputFileName1)
  inputFile2 = open(options.inputFileName2)
  outputFile = open(options.outputFileName, "w")
  
  for line1 in inputFile1:
    line1 = line1.strip()
    
    line2 = inputFile2.readline().strip()
    
    if line2 == "":
      sys.exit("Second file is shorter! Aborting...")
      
    m = re.search(r"^\s*(\S+)\s+(\d+\.?\d*)\s*$", line1)
    if m == None:
      sys.exit("Line '%s' of first file is wrong! Aborting" % (line1))
    name1  = m.group(1)
    value1 = float(m.group(2))

    m = re.search(r"^\s*(\S+)\s+(\d+\.?\d*)\s*$", line2)
    if m == None:
      sys.exit("Line '%s' of second file is wrong! Aborting" % (line2))
    name2  = m.group(1)
    value2 = float(m.group(2))

    if name1 != name2:
      sys.exit("Names '%s' and '%s' of the files differ! Aborting" % (name1, name2))
      
    outputFile.write("%s\t%f\t%f\n" % (name1, value1, value2))
    
  line2 = inputFile2.readline()
  if line2 != "":
    sys.exit("First file is shorter! Aborting...")
      
  outputFile.close()
  inputFile1.close()
  inputFile2.close()
  
