#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
"""Remove sequences with low reliability"""

from optparse import OptionParser
from commons.core.parsing.SequenceListParser import *
from commons.core.writer.FastaWriter import *
from SMART.Java.Python.misc.Progress import *


if __name__ == "__main__":
    
    # parse command line
    description = "Trim Sequences v1.0.1: Remove sequences with low reliability: low occurrences and highly repeted. [Category: Personnal]"

    parser = OptionParser(description = description)
    parser.add_option("-i", "--input",         dest="inputFileName",    action="store",                                         type="string", help="input file [compulsory] [format: file in FASTA format]")
    parser.add_option("-o", "--output",        dest="outputFileName", action="store",                                         type="string", help="output file [compulsory] [format: output file in FASTA format]")
    parser.add_option("-v", "--verbosity", dest="verbosity",            action="store",            default=1,         type="int",        help="trace level [format: int]")
    parser.add_option("-l", "--log",             dest="log",                        action="store_true", default=False,                                help="write a log file [format: bool] [default: false]")
    (options, args) = parser.parse_args()

    parser            = SequenceListParser(options.inputFileName, options.verbosity)
    nbSequences = parser.getNbSequences()
    progress        = Progress(nbSequences, "Parsing file %s" % (options.inputFileName), options.verbosity)
    
    writer = FastaWriter(options.outputFileName, options.verbosity)
    if options.log:
        logHandle = open("log.txt", "w")
    
    letters                            = ("A", "C", "G", "T")
    nbLowComplexity            = 0
    nbTooManyOccurrences = 0
    
    for sequence in parser.getIteractor():
        halfSize                     = len(sequence.sequence) / 2
        occurrences                = set()
        nbOccurrences            = dict(zip(letters, [0 for letter in letters]))
        tooManyOccurrences = False
        good                             = True
        
        for char in sequence.sequence:
            if char in letters:
                occurrences.add(char)
                nbOccurrences[char] += 1
                
            
        if len(occurrences) < 4:
            nbLowComplexity += 1
            if options.log:
                logHandle.write("Low complexity for %s\n" % (sequence.sequence))
            good = False

        if good:
            for letter, nbOccurrence in nbOccurrences.iteritems():
                if nbOccurrence > halfSize:
                    if not tooManyOccurrences:
                        nbTooManyOccurrences += 1
                        if options.log:
                            logHandle.write("Too many occurrences for %s\n" % (sequence.sequence))
                    tooManyOccurrences = True
                    good = False
            
        if good:
            writer.addSequence(sequence)
                    
        progress.inc()
    progress.done()
    
    if options.log:
        logHandle.close()
        
    print "%d out of %d have low complexity (%f%%)"             % (nbLowComplexity, nbSequences, (float(nbLowComplexity) / nbSequences * 100))        
    print "%d out of %d have too many occurrences (%f%%)" % (nbTooManyOccurrences, nbSequences, (float(nbTooManyOccurrences) / nbSequences * 100))
