#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
import sys
from commons.core.parsing.SequenceListParser import SequenceListParser
from SMART.Java.Python.structure.Sequence import Sequence

class FastqParser(SequenceListParser):
    """A class that reads a list of sequences in FASTQ format"""

    def __init__(self, fileName, verbosity = 0):
        super(FastqParser, self).__init__(fileName, verbosity)


    def getFileFormats():
        return ["fastq", "mfq"]
    getFileFormats = staticmethod(getFileFormats)


    def getInfos(self):
        """
        Get some generic information about the sequences
        """
        self.nbSequences = 0
        self.reset()
        if self.verbosity >= 10:
            print "Getting information on %s." % (self.fileName)

        nbLines = 0
        for line in self.handle:
            line = line.strip()
            if line == "":
                continue
            nbLines += 1
            if self.verbosity >= 10 and nbLines % 400000 == 0:
                sys.stdout.write("    %d sequences read\r" % (nbLines / 4))
                sys.stdout.flush()
        self.reset()
        self.nbSequences = nbLines / 4
        if self.verbosity >= 10:
            print "    %d sequences read" % (self.nbSequences)
            print "Done."


    def parseOne(self):
        """
        Parse only one element in the file
        """
        string = ""
        quality = ""
        lineType = 0

        for line in self.handle:
            line = line.strip()
            if lineType == 0:
                if line[0] != "@":
                    raise Exception("Line '%s' should start with '@'!" % (line))
                name = line[1:]
                inSequence = True
                inQuality = False
            elif lineType == 1:
                string = line
            elif lineType == 2:
                if line[0] != "+":
                    sys.exit("Line '%s' should start with '+'!" % (line))
                if line[1:] != name and line != "+":
                    sys.exit("Weird difference in sequence and quality names (%s and %s) while parsing FASTQ file %s." % (name, line[1:], self.fileName))
                inQuality = True
                inSequence = False
            elif lineType == 3:
                quality = line
            lineType += 1
            if lineType == 4:
                sequence = Sequence(name, string)
                sequence.setQuality(quality)
                return sequence
                
        return None
