#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
import re
import sys
from SMART.Java.Python.structure.Mapping import Mapping
from commons.core.parsing.MapperParser import MapperParser


class SoapParser(MapperParser):
    """A class that parses the output of SOAP"""

    def __init__(self, fileName, verbosity = 0):
        super(SoapParser, self).__init__(fileName, verbosity)


    def __del__(self):
        super(SoapParser, self).__del__()


    def getFileFormats():
        return ["soap"]
    getFileFormats = staticmethod(getFileFormats)


    def skipFirstLines(self):
        pass


    def parseLine(self, line):
        m = re.search(r"^\s*(\S+)\s+(\w+)\s+(\w+)\s+(\d+)\s+(a)\s+(\d+)\s+([+-])\s+(\w+)\s+(\d+)\s+(\d+)", line)
        if m == None:
            sys.exit("\nLine %d '%s' does not have a SOAP format" % (self.currentLineNb, line))

        mapping = Mapping()

        mapping.queryInterval.setName(m.group(1))
        mapping.queryInterval.setStart(1)
        mapping.queryInterval.setSize(len(m.group(2)))

        mapping.targetInterval.setChromosome(m.group(8))
        mapping.targetInterval.setStart(int(m.group(9)))
        mapping.targetInterval.setSize(len(m.group(2)))

        mapping.setDirection(m.group(7))
        mapping.setSize(len(m.group(2)))
        mapping.setNbMismatches(int(m.group(10)))

        return mapping
