# Copyright INRA (Institut National de la Recherche Agronomique)
# http://www.inra.fr
# http://urgi.versailles.inra.fr
#
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software.  You can  use, 
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info". 
#
# As a counterpart to the access to the source code and  rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty  and the software's author,  the holder of the
# economic rights,  and the successive licensors  have only  limited
# liability. 
#
# In this respect, the user's attention is drawn to the risks associated
# with loading,  using,  modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean  that it is complicated to manipulate,  and  that  also
# therefore means  that it is reserved for developers  and  experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or 
# data to be ensured and,  more generally, to use and operate it in the 
# same conditions as regards security. 
#
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.


from commons.core.checker.CheckerException import CheckerException
from commons.core.parsing.VarscanHit import VarscanHit

class VarscanHit_v2_2_8(VarscanHit):
    
    def __init__(self, chrom = "", position = "", ref = "", cns = "", readsRef = "", readsVar = "", varFreq = "", strandsRef = "", strandsVar = "", qualRef = "", qualVar = "", pValue = "", mapQualRef = "", mapQualVar = "", readsRefPlus = "", readsRefMinus = "", readsVarPlus = "", readsVarMinus = "", var = ""):
        self._cns = cns
        self._mapQualRef = mapQualRef
        self._mapQualVar = mapQualVar
        self._readsRefPlus = readsRefPlus
        self._readsRefMinus = readsRefMinus
        self._readsVarPlus = readsVarPlus
        self._readsVarMinus = readsVarMinus
        VarscanHit.__init__(self, chrom, position, ref, var, readsRef, readsVar, varFreq, strandsRef, strandsVar, qualRef, qualVar, pValue)
        
    ## Equal operator
    #
    # @param o a VarscanFileAnalysis instance
    #    
    def __eq__(self, o):
        if self._cns == o._cns:
            return VarscanHit.__eq__(self, o)
        return False
    
    def setCns(self, consensus):
        self._cns = consensus
        
    def setMapQualRef(self, mapQualRef):
        self._mapQualRef = mapQualRef
        
    def setMapQualVar(self, mapQualVar):
        self._mapQualVar = mapQualVar
        
    def setReadsRefPlus(self, readsRefPlus):
        self._readsRefPlus = readsRefPlus
        
    def setReadsRefMinus(self, readsRefMinus):
        self._readsRefMinus = readsRefMinus
        
    def setReadsVarPlus(self, readsVarPlus):
        self._readsVarPlus = readsVarPlus
        
    def setReadsVarMinus(self, readsVarMinus):
        self._readsVarMinus = readsVarMinus
    
    def getCns(self):
        return self._cns
        
    def getMapQualRef(self):
        return self._mapQualRef
        
    def getMapQualVar(self):
        return self._mapQualVar
        
    def getReadsRefPlus(self):
        return self._readsRefPlus
        
    def getReadsRefMinus(self):
        return self._readsRefMinus
        
    def getReadsVarPlus(self):
        return self._readsVarPlus
        
    def getReadsVarMinus(self):
        return self._readsVarMinus
    
    def getHeader(self):
        return "Chrom\tPosition\tRef\tCons\tReads1\tReads2\tVarFreq\tStrands1\tStrands2\tQual1\tQual2\tPvalue\tMapQual1\tMapQual2\tReads1Plus\tReads1Minus\tReads2Plus\tReads2Minus\tVarAllele\n"
    
    def getVarscanLine(self):
        return "%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\n" % (self.getChrom(), self.getPosition(), self.getRef(), self.getCns(), self.getReadsRef(), self.getReadsVar(), self.getVarFreq(), self.getStrandsRef(), self.getStrandsVar(),  self.getQualRef(), self.getQualVar(), self.getPValue(), self.getMapQualRef(), self.getMapQualVar(), self.getReadsRefPlus(), self.getReadsRefMinus(), self.getReadsVarPlus(), self.getReadsVarMinus(), self.getVar())
    
    def setAttributes(self, lResults, iCurrentLineNumber):
        if lResults[0] != '':
            self.setChrom(lResults[0])
        else:
            raise CheckerException ("The field Chrom is empty in varscan file in line %s" % iCurrentLineNumber)
        if lResults[1] != '':
            self.setPosition(lResults[1])
        else:
            raise CheckerException ("The field Position is empty in varscan file in line %s" % iCurrentLineNumber)
        if lResults[2] != '':
            self.setRef(lResults[2])
        else:
            raise CheckerException ("The field Ref is empty in varscan file in line %s" % iCurrentLineNumber)
        if lResults[3] != '':
            self.setCns(lResults[3])
        else:
            raise CheckerException ("The field Cons is empty in varscan file in line %s" % iCurrentLineNumber)
        if lResults[4] != '':
            self.setReadsRef(lResults[4])
        if lResults[5] != '':
            self.setReadsVar(lResults[5])
        if lResults[6] != '':
            self.setVarFreq(lResults[6])
        if lResults[7] != '':
            self.setStrandsRef(lResults[7])
        if lResults[8] != '':
            self.setStrandsVar(lResults[8])
        if lResults[9] != '':
            self.setQualRef(lResults[9])
        if lResults[10] != '':
            self.setQualVar(lResults[10])
        if lResults[11] != '':
            self.setPValue(lResults[11])
        if lResults[12] != '':
            self.setMapQualRef(lResults[12])
        if lResults[13] != '':
            self.setMapQualVar(lResults[13])
        if lResults[14] != '':
            self.setReadsRefPlus(lResults[14])
        if lResults[15] != '':
            self.setReadsRefMinus(lResults[15])
        if lResults[16] != '':
            self.setReadsVarPlus(lResults[16])
        if lResults[17] != '':
            self.setReadsVarMinus(lResults[17])
        if lResults[18] != '':
            self.setVar(lResults[18])
        else:
            raise CheckerException ("The field varAllele is empty in varscan file in line %s" % iCurrentLineNumber)
            
    def setAttributesFromString(self, varscanString, iCurrentLineNumber ="", fieldSeparator ="\t"):
        varscanString = varscanString.rstrip()
        lvarscanStringItem = varscanString.split(fieldSeparator)
        if len(lvarscanStringItem) < 19:
            raise CheckerException ("This varscan line (l.%s) is not complete" % iCurrentLineNumber)
        self.setAttributes(lvarscanStringItem, iCurrentLineNumber)
        
    def convertVarscanHit_v2_2_8_To_VarscanHit(self):
        iVarscanHit = VarscanHit()
        iVarscanHit.setChrom(self.getChrom())
        iVarscanHit.setPosition(self.getPosition())
        iVarscanHit.setRef(self.getRef())
        iVarscanHit.setVar(self.getVar())
        iVarscanHit.setReadsRef(self.getReadsRef())
        iVarscanHit.setReadsVar(self.getReadsVar())
        iVarscanHit.setVarFreq(self.getVarFreq())
        iVarscanHit.setStrandsRef(self.getStrandsRef())
        iVarscanHit.setStrandsVar(self.getStrandsVar())
        iVarscanHit.setQualRef(self.getQualRef())
        iVarscanHit.setQualVar(self.getQualVar())
        iVarscanHit.setPValue(self.getPValue())
        return iVarscanHit
        