#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
"""Get a given sequence in a multi-Fasta file"""
import sys
from optparse import OptionParser
from commons.core.parsing.FastaParser import FastaParser
from SMART.Java.Python.misc.Progress import Progress
from commons.core.writer.FastaWriter import FastaWriter

if __name__ == "__main__":
    
    # parse command line
    description = "Get Sequence v1.0.1: Get a single sequence in a FASTA file. [Category: Data Selection]"

    parser = OptionParser(description = description)
    parser.add_option("-i", "--input", dest="inputFileName",action="store",type="string", help="multi-FASTA file [compulsory] [format: file in FASTA format]")
    parser.add_option("-n", "--name",dest="name",action="store",type="string", help="name of the sequence [compulsory] [format: string]")
    parser.add_option("-o", "--output",dest="outputFileName",action="store",type="string", help="output sequence file (FASTA) [compulsory] [format: file in FASTA format]")
    parser.add_option("-v", "--verbosity", dest="verbosity",action="store",default=1,type="int",help="trace level [format: int]")
    (options, args) = parser.parse_args()

    # read Fasta file
    sequenceListParser = FastaParser(options.inputFileName, options.verbosity)
    for sequence in sequenceListParser.getIterator():
        name = sequence.name.split(" ")[0]
        if name == options.name:
            writer = FastaWriter(options.outputFileName, options.verbosity)
            writer.addSequence(sequence)
            print sequence.printFasta(),
            sys.exit(0)
    writer.close()
    print "No sequence found"
