#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2011
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
import random
from optparse import OptionParser
from commons.core.parsing.ParserChooser import ParserChooser
from commons.core.writer.TranscriptWriter import TranscriptWriter
from SMART.Java.Python.structure.Transcript import Transcript
from SMART.Java.Python.misc.Progress import Progress

class GetRandomSubset(object):

    def __init__(self, verbosity):
        self.verbosity = verbosity

    def setInputFile(self, fileName, format):
        chooser = ParserChooser(self.verbosity)
        chooser.findFormat(format)
        self.parser = chooser.getParser(fileName)

    def setNumber(self, number, percent):
        if number != None:
            self.number = number
        elif percent != None:
            self.number = int(float(percent) / 100 * self.parser.getNbTranscripts())
        else:
            raise Exception("Error! Number of elements to output is not given!")

    def setOutputFile(self, fileName):
        self.writer = TranscriptWriter(fileName, "gff3", self.verbosity)

    def chooseElements(self):
        self.randomIndices = random.sample(range(self.parser.getNbTranscripts()), self.number)
        
    def run(self):
        self.chooseElements()
        progress  = Progress(self.parser.getNbTranscripts(), "Reading input file", self.verbosity)
        nbWritten = 0
        for cpt1, transcript in enumerate(self.parser.getIterator()):
            if cpt1 in self.randomIndices:
                self.writer.addTranscript(transcript)
                nbWritten += 1
            progress.inc()
        self.writer.write()
        self.writer.close()
        progress.done()
        if self.verbosity > 1:
            print "%d transcripts read" % (self.parser.getNbTranscripts())
            print "%d transcripts written" % (nbWritten)


if __name__ == "__main__":
    
    description = "Get Random Subset v1.0.1: Get a random sub-set of a list of genomic coordinates. [Category: Personal]"

    parser = OptionParser(description = description)
    parser.add_option("-i", "--input",     dest="inputFileName",  action="store",               type="string", help="input file [compulsory] [format: file in transcript format given by -f]")
    parser.add_option("-f", "--format",    dest="format",         action="store",               type="string", help="format of file [compulsory] [format: transcript file format]")
    parser.add_option("-n", "--number",    dest="number",         action="store", default=None, type="string", help="number of elements to output [format: int]")
    parser.add_option("-p", "--percent",   dest="percent",        action="store", default=None, type="string", help="percentage of elements to output (between 0 and 100) [format: int]")
    parser.add_option("-o", "--output",    dest="outputFileName", action="store",               type="string", help="output file [format: output file in GFF3 format]")
    parser.add_option("-v", "--verbosity", dest="verbosity",      action="store", default=1,    type="int", help="trace level [format: int]")
    (options, args) = parser.parse_args()

    grs = GetRandomSubset(options.verbosity)
    grs.setInputFile(options.inputFileName, options.format)
    grs.setNumber(options.number, options.percent)
    grs.setOutputFile(options.outputFileName)
    grs.run()
