#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#

import os
import struct
from optparse import OptionParser
from commons.core.parsing.GffParser import GffParser
from commons.core.writer.Gff3Writer import Gff3Writer

LONGSIZE = struct.calcsize('l')

class FindOverlaps_naif(object):
    
    def __init__(self, inputRefGff3FileName, inputQueryGff3FileName):
        self._inputRefGff3FileName = inputRefGff3FileName
        self._inputQueryGff3FileName = inputQueryGff3FileName
                
    def close(self):
        self._iGff3Writer.close()
    
    def setGff3FileName(self, fileName):
        self._inputRefGff3FileName = fileName
        
    def setQueryGff3FileName(self, fileName):
        self._inputQueryGff3FileName = fileName
    
    def setOutputGff3FileName(self, outputGff3FileName):
        if outputGff3FileName != '':
            self._outputGff3FileName = outputGff3FileName
        self._iGff3Writer = Gff3Writer(self._outputGff3FileName)
                
    def run(self):
        queryParser = GffParser(self._inputQueryGff3FileName, 0)
        for queryTranscript in queryParser.getIterator():
            ids       = []
            refParser = GffParser(self._inputRefGff3FileName, 0)
            for refTranscript in refParser.getIterator():
                if queryTranscript.overlapWith(refTranscript):
                    ids.append(refTranscript.getTagValue('ID'))
            if ids:
                queryTranscript.setTagValue("nbOverlaps", len(ids))
                queryTranscript.setTagValue("overlapsWith", "--".join(ids))
                self._iGff3Writer.addTranscript(queryTranscript)
    
if __name__ == "__main__":
    description = "FindOverlapsWithSeveralInterval: Finds overlaps with several query intervals."

    parser = OptionParser(description = description)
    parser.add_option("-i", "--inputRef", dest="inputRefGff3FileName", action="store", type="string", help="Reference input file [compulsory] [format: file in gff3 format]")
    parser.add_option("-j", "--inputQuery", dest="inputQueryGff3FileName", action="store", type="string", help="Query input file [compulsory] [format: file in gff3 format]")
    parser.add_option("-o", "--output", dest="outputGff3FileName", action="store", type="string", help="output file [compulsory] [format: output file in gff3 format]")
    (options, args) = parser.parse_args()
    
    iFON = FindOverlaps_naif(options.inputRefGff3FileName, options.inputQueryGff3FileName)
    iFON.setOutputGff3FileName(options.outputGff3FileName)
    iFON.run()
    iFON.close()
