import unittest
import os
import time
from SMART.Java.Python.misc import Utils
from SMART.Java.Python.ncList.test.MockFindOverlaps_randomExample import *
from SMART.Java.Python.ncList.FindOverlaps_naif import FindOverlaps_naif
from SMART.Java.Python.FindOverlapsOptim import FindOverlapsOptim

class Test_FindOverlaps_randomExample(unittest.TestCase):

    def setUp(self):
        self._output_naif = 'output_naif.gff3'
        self._outputOptim = 'outputOptim.gff3'

        
    def tearDown(self):
        return
        os.remove(self._output_naif)
        os.remove(self._outputOptim)
        
    def test_run_smallSize(self):
        inputRefGff3FileName = 'ref_small.gff3'
        numberOfReads = 10
        chromSize = 1000
        iMFO_rand = MockFindOverlaps_randomExample(inputRefGff3FileName, 'reference', numberOfReads, chromSize)
        iMFO_rand.write()

        inputQueryGff3FileName = 'query_small.gff3'
        iMFO_rand = MockFindOverlaps_randomExample(inputQueryGff3FileName,'query', 10, 1000)
        iMFO_rand.write()
        
        iFON = FindOverlaps_naif(inputRefGff3FileName, inputQueryGff3FileName)
        iFON.setOutputGff3FileName(self._output_naif)
        iFOO = FindOverlapsOptim(0)
        iFOO.setRefFileName(inputRefGff3FileName, "gff3")
        iFOO.setQueryFileName(inputQueryGff3FileName, "gff3")
        iFOO.setOutputFileName(self._outputOptim)
        iFOO.prepareIntermediateFiles()
        iFOO.createNCLists()
        
        startTime_naif = time.time()
        iFON.run()
        iFON.close()
        endTime_naif = time.time()
        totalTime_naif = endTime_naif - startTime_naif
        print 'for naive algo, we take %e second' % (totalTime_naif)
        
        startTimeOptim = time.time()
        iFOO.compare()
        endTimeOptim = time.time()
        totalTimeOptim = endTimeOptim - startTimeOptim
        print 'for optim algo, we take %e second' % (totalTimeOptim)
        iFOO.close()
        
        self.assertTrue(Utils.diff(self._output_naif, self._outputOptim)) 
        
        os.remove(inputRefGff3FileName)
        os.remove(inputQueryGff3FileName)
      

    def test_creatRandomExampleWithMOverlaps_smallSize(self):
        inputRefGff3FileName = 'refMOverlaps_small.gff3'
        inputQueryGff3FileName = 'queryMOverlaps_small.gff3'       
        numberOfReads = 10
        chromSize = 1000 
        iRMSS = MockFindOverlaps_randomExample_MOverlaps(inputRefGff3FileName, inputQueryGff3FileName, 7, numberOfReads, chromSize)
        iRMSS.createRandomExample()
  
  
        iFON = FindOverlaps_naif(inputRefGff3FileName, inputQueryGff3FileName)
        iFON.setOutputGff3FileName(self._output_naif)
        iFOO = FindOverlapsOptim(0)
        iFOO.setRefFileName(inputRefGff3FileName, "gff3")
        iFOO.setQueryFileName(inputQueryGff3FileName, "gff3")
        iFOO.setOutputFileName(self._outputOptim)
        iFOO.prepareIntermediateFiles()
        iFOO.createNCLists()
        
        startTime_naif = time.time()
        iFON.run()
        endTime_naif = time.time()
        totalTime_naif = endTime_naif - startTime_naif
        print 'for naive algo, we take %e second' % (totalTime_naif)
        iFON.close()
        
        startTimeOptim = time.time()
        iFOO.compare()
        endTimeOptim = time.time()
        totalTimeOptim = endTimeOptim - startTimeOptim
        print 'for optim algo, we take %e second' % (totalTimeOptim)
        iFOO.close()        
        
        self.assertTrue(Utils.diff(self._output_naif, self._outputOptim)) 
        
        os.remove(inputRefGff3FileName)
        os.remove(inputQueryGff3FileName)        
        
if __name__ == "__main__":
    unittest.main()
