/**
 *
 * Copyright INRA-URGI 2009-2010
 * 
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software. You can use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 * 
 * As a counterpart to the access to the source code and rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty and the software's author, the holder of the
 * economic rights, and the successive licensors have only limited
 * liability.
 * 
 * In this respect, the user's attention is drawn to the risks associated
 * with loading, using, modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean that it is complicated to manipulate, and that also
 * therefore means that it is reserved for developers and experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and, more generally, to use and operate it in the
 * same conditions as regards security.
 * 
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */
import java.util.*;
import java.io.File;
import java.io.*;


public class FormatsReader {

  String fileName;
  Vector < FormatType > formatTypes;
  Vector < String > typeNames;


  public FormatsReader(String fileName) {
    this.fileName    = fileName;  
    this.formatTypes = new Vector < FormatType > ();
  }


  public boolean read() {
    File file = new File(this.fileName);

    try {
      BufferedReader reader = new BufferedReader(new FileReader(file));
      String     line = null;
      String[]   lineElements;
      String[]   formats;
      String     typeName;

      while ((line = reader.readLine()) != null) {
        if (line.length() > 0) {
          lineElements = line.split(":");
          typeName     = lineElements[0].trim();
          formats      = lineElements[1].split(",");
          for (int i = 0; i < formats.length; i++) {
            Global.formats.addFormat(typeName, formats[i].trim());
          }
        }
      }

      reader.close();
    }
    catch (FileNotFoundException e) {
      return false;
    }
    catch (IOException e) {
      return false;
    }

    return true;
  }
}

