#! /usr/bin/env python
"""Split a FASTA file into several shorter ones"""

from optparse import OptionParser
from parsing.sequenceListParser import *
from writer.fastaWriter import *
from misc.progress import *


if __name__ == "__main__":
  
  # parse command line
  description = "Sequence List Splitter: Split a list of big sequences into small chunks. [Category: Personnal]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",     dest="inputFileName",   action="store",                     type="string", help="input file [compulsory] [format: file in FASTA format]")
  parser.add_option("-o", "--output",    dest="outputFileNames", action="store",                     type="string", help="output files [compulsory] [format: output FASTA file]")
  parser.add_option("-n", "--number",    dest="number",          action="store",      default=10,    type="int",    help="number of splits [compulsory] [format: int] [default: 10]")
  parser.add_option("-v", "--verbosity", dest="verbosity",       action="store",      default=1,     type="int",    help="trace level [format: int]")
  parser.add_option("-l", "--log",       dest="log",             action="store_true", default=False,                help="write a log file [format: bool] [default: false]")
  (options, args) = parser.parse_args()

  if options.log:
    logHandle = open(options.outputFileNames + ".log", "w")

  # split file
  sequenceListParser = SequenceListParser(options.inputFileName, options.verbosity)
  nbSequences        = sequenceListParser.getNbSequences()
  nbSequencesByFile  = math.ceil(nbSequences / options.number)

  # write into files
  currentFileNumber = 1
  writer            = FastaWriter("%s%i.fasta" % (options.outputFileNames, currentFileNumber), options.verbosity)
  nbSequencesHere   = 0
  progress          = Progress(nbSequences, "Writing files", options.verbosity)
  for sequence in sequenceListParser.getIterator():
    writer.addSequence(sequence)
    nbSequencesHere += 1
    if nbSequencesHere == nbSequencesByFile:
      currentFileNumber += 1
      writer             = FastaWriter("%s%i.fasta" % (options.outputFileNames, currentFileNumber), options.verbosity)
      nbSequencesHere    = 0
    progress.inc()
  progress.done()
