import unittest
import os
from commons.core.seq.ClusterConsensusCollection import ClusterConsensusCollection
from commons.core.seq.Bioseq import Bioseq
from commons.core.seq.BioseqDB import BioseqDB

class TestClusterConsensusCollection(unittest.TestCase):

    def setUp(self):
        self._clusterSequencesFileName = "clusterSequences.fa"
        self._ClusterConsensusCollection = ClusterConsensusCollection(self._clusterSequencesFileName)
        self._createClusterConsensusFile()

    def tearDown(self):
        os.remove(self._clusterSequencesFileName)
        
    def test_fillCollection(self):
        expClusterConsensusCollection = ClusterConsensusCollection(self._clusterSequencesFileName)
        expClusterConsensusCollection._clusterFileName = self._clusterSequencesFileName
        bioseq1 = Bioseq("seq1", "ACCAAAGACACTAGAATAACAAGATGCGTAACGCCATACGATTTTTTGGCACACTATTTT")
        bioseq2 = Bioseq("seq2", "ACCAAAGACACTAGAATAACAAGATGCGTAACGCCATACGATTTTTTGGCACACTATTTT")
        bioseq3 = Bioseq("seq3", "ACCAAAGACACTAGAATAACAAGATGCGTAACGCCATACGATTTTTTGGCACACTATTTT")
        iBioseqDB1 = BioseqDB()
        iBioseqDB2 = BioseqDB()
        iBioseqDB1.setData([bioseq1, bioseq2])
        iBioseqDB2.setData([bioseq3])
        expClusterConsensusCollection._lClusterConsensus = [iBioseqDB1, iBioseqDB2]
        self._ClusterConsensusCollection.fillCollection()
        self.assertEqual(expClusterConsensusCollection, self._ClusterConsensusCollection)
        
    def test_getNumClusterForAConsensus_for_seq2(self):
        self._ClusterConsensusCollection.fillCollection()
        expClusterNumber = 1
        obsClusterNumber = self._ClusterConsensusCollection.getNumClusterForAConsensus ("seq2")
        self.assertEqual(expClusterNumber, obsClusterNumber)
        
    def test_getNumClusterForAConsensus_for_seq3(self):
        self._ClusterConsensusCollection.fillCollection()
        expClusterNumber = 2
        obsClusterNumber = self._ClusterConsensusCollection.getNumClusterForAConsensus ("seq3")
        self.assertEqual(expClusterNumber, obsClusterNumber)
        
    def test_getNumConsensusInCluster_1(self):
        self._ClusterConsensusCollection.fillCollection()
        expConsensusNumber = 2
        obsConsensusNumber = self._ClusterConsensusCollection.getNumConsensusInCluster (1)
        self.assertEqual(expConsensusNumber, obsConsensusNumber)
        
    def test_getNumConsensusInCluster_2(self):
        self._ClusterConsensusCollection.fillCollection()
        expConsensusNumber = 1
        obsConsensusNumber = self._ClusterConsensusCollection.getNumConsensusInCluster (2)
        self.assertEqual(expConsensusNumber, obsConsensusNumber)
    
    def _createClusterConsensusFile(self):
        fCluster = open(self._clusterSequencesFileName, "w")
        fCluster.write(">BlastclustCluster1Mb1 seq1\n")
        fCluster.write("ACCAAAGACACTAGAATAACAAGATGCGTAACGCCATACGATTTTTTGGCACACTATTTT\n")
        fCluster.write(">BlastclustCluster1Mb2 seq2\n")
        fCluster.write("ACCAAAGACACTAGAATAACAAGATGCGTAACGCCATACGATTTTTTGGCACACTATTTT\n")
        fCluster.write(">BlasterGrouperCluster3Mb1 seq3\n")
        fCluster.write("ACCAAAGACACTAGAATAACAAGATGCGTAACGCCATACGATTTTTTGGCACACTATTTT\n")
        fCluster.close()


if __name__ == "__main__":
    unittest.main()