# Copyright INRA (Institut National de la Recherche Agronomique)
# http://www.inra.fr
# http://urgi.versailles.inra.fr
#
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software.  You can  use, 
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info". 
#
# As a counterpart to the access to the source code and  rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty  and the software's author,  the holder of the
# economic rights,  and the successive licensors  have only  limited
# liability. 
#
# In this respect, the user's attention is drawn to the risks associated
# with loading,  using,  modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean  that it is complicated to manipulate,  and  that  also
# therefore means  that it is reserved for developers  and  experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or 
# data to be ensured and,  more generally, to use and operate it in the 
# same conditions as regards security. 
#
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.


class Utils_for_T_FastaUtils( object ):
    
    def _createFastaFile_for_empty_file(fileName):
        f = open(fileName, 'w')
        f.write("")
        f.close()
        
    _createFastaFile_for_empty_file = staticmethod ( _createFastaFile_for_empty_file )
    
    
    def _createFastaFile_one_sequence(fileName):
        f = open(fileName, 'w')
        f.write(">seq 1\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createFastaFile_one_sequence = staticmethod ( _createFastaFile_one_sequence )
    
    
    def createFastaFile_twoSequences( fileName ):
        f = open( fileName, "w" )
        f.write( ">seq 1\n" )
        f.write( "ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n" )
        f.write( "ATATTCG\n" )
        f.write( ">seq 2\n" )
        f.write( "ATATTCTTTCATCGATCGATCGGCGGCTATATGCTAGTGACGAAGCTAGTGTGAGTAGTA\n" )
        f.write( "ATATTCG\n" )
        f.close()
        
    createFastaFile_twoSequences = staticmethod ( createFastaFile_twoSequences )
    
    
    def createFastaFile_seq_1( fileName ):
        f = open( fileName, "w" )
        f.write( ">seq 1\n" )
        f.write( "ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n" )
        f.write( "ATATTCG\n" )
        f.close()
        
    createFastaFile_seq_1 = staticmethod( createFastaFile_seq_1 )
    
    
    def createFastaFile_seq_2( fileName ):
        f = open( fileName, "w" )
        f.write( ">seq 2\n" )
        f.write( "ATATTCTTTCATCGATCGATCGGCGGCTATATGCTAGTGACGAAGCTAGTGTGAGTAGTA\n" )
        f.write( "ATATTCG\n" )
        f.close()
        
    createFastaFile_seq_2 = staticmethod( createFastaFile_seq_2 )
    
    
    def _createFastaFile_sequence_without_header(fileName):
        f = open(fileName, 'w')
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createFastaFile_sequence_without_header = staticmethod ( _createFastaFile_sequence_without_header )
    
        
    def _createFastaFile_four_sequences(fileName):
        f = open(fileName, 'w')
        f.write(">seq 1\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">seq 2\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">seq 3\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">seq 4\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createFastaFile_four_sequences = staticmethod ( _createFastaFile_four_sequences )
    
    
    def _createFastaFile_three_sequences(fileName):
        f = open(fileName, 'w')
        f.write(">seq 1\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">seq 2\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">seq 4\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createFastaFile_three_sequences = staticmethod ( _createFastaFile_three_sequences )
    
    
# ------------------ for dbSplit ---------------- #

    def _createBatch1_two_sequences(inFileName):
        f = open(inFileName, 'w')
        f.write(">seq 1\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">seq 2\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createBatch1_two_sequences = staticmethod ( _createBatch1_two_sequences )
    
    
    def _createBatch2_two_sequences(inFileName):
        f = open(inFileName, 'w')
        f.write(">seq 3\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">seq 4\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createBatch2_two_sequences = staticmethod ( _createBatch2_two_sequences )
    
    
    def _createBatch1_three_sequences(inFileName):
        f = open(inFileName, 'w')
        f.write(">seq 1\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">seq 2\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">seq 3\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createBatch1_three_sequences = staticmethod ( _createBatch1_three_sequences )
    
    
    def _createBatch2_one_sequence(inFileName):
        f = open(inFileName, 'w')
        f.write(">seq 4\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createBatch2_one_sequence = staticmethod ( _createBatch2_one_sequence )
    
    
    def _createFastaFile_ten_sequences(fileName):
        f = open(fileName, 'w')
        f.write(">seq 1\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write(">seq 2\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write(">seq 3\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write(">seq 4\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write(">seq 5\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write(">seq 6\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write(">seq 7\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write(">seq 8\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write(">seq 9\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write(">seq 10\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.close()
        
    _createFastaFile_ten_sequences = staticmethod ( _createFastaFile_ten_sequences )
    
    
    def _createBatch_one_small_sequence(fileName, seqName):
        f = open(fileName, 'w')
        f.write(">" +seqName + "\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.close()
        
    _createBatch_one_small_sequence = staticmethod ( _createBatch_one_small_sequence )
    
    
# ------------------ for dbChunks ------------------- #

    def _createFastaFile_big_sequence(fileName):
        f = open(fileName, 'w')
        f.write(">sequence\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createFastaFile_big_sequence = staticmethod ( _createFastaFile_big_sequence )
    
    
    def _createFastaFile_of_Chunks(fileName):
        f = open(fileName, 'w')
        f.write('>chunk01\n')
        f.write('ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n')
        f.write('>chunk02\n')
        f.write('GTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGT\n')
        f.write('>chunk03\n')
        f.write('GCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCA\n')
        f.write('>chunk04\n')
        f.write('ATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTAT\n')
        f.write('>chunk05\n')
        f.write('CGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGAT\n')
        f.write('>chunk06\n')
        f.write('ATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGC\n')
        f.write('>chunk07\n')
        f.write('ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n')
        f.write('>chunk08\n')
        f.write('GTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGT\n')
        f.write('>chunk09\n')
        f.write('GCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCA\n')
        f.write('>chunk10\n')
        f.write('ATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTAT\n')
        f.write('>chunk11\n')
        f.write('CGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGAT\n')
        f.write('>chunk12\n')
        f.write('ATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGC\n')
        f.write('>chunk13\n')
        f.write('ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n')
        f.write('>chunk14\n')
        f.write('GTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGT\n')
        f.write('>chunk15\n')
        f.write('GCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCA\n')
        f.write('>chunk16\n')
        f.write('ATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTAT\n')
        f.write('>chunk17\n')
        f.write('CGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGAT\n')
        f.write('>chunk18\n')
        f.write('ATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGC\n')
        f.write('>chunk19\n')
        f.write('ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n')
        f.write('>chunk20\n')
        f.write('GTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGT\n')
        f.write('>chunk21\n')
        f.write('GCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCA\n')
        f.write('>chunk22\n')
        f.write('ATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTAT\n')
        f.write('>chunk23\n')
        f.write('CGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCG\n')
        f.close()
        
    _createFastaFile_of_Chunks = staticmethod ( _createFastaFile_of_Chunks )
    
    
    def _createMapFile_of_Chunks(fileName):
        f = open(fileName, 'w')
        f.write("chunk01\tsequence\t1\t60\n")
        f.write("chunk02\tsequence\t51\t110\n")
        f.write("chunk03\tsequence\t101\t160\n")
        f.write("chunk04\tsequence\t151\t210\n")
        f.write("chunk05\tsequence\t201\t260\n")
        f.write("chunk06\tsequence\t251\t310\n")
        f.write("chunk07\tsequence\t301\t360\n")
        f.write("chunk08\tsequence\t351\t410\n")
        f.write("chunk09\tsequence\t401\t460\n")
        f.write("chunk10\tsequence\t451\t510\n")
        f.write("chunk11\tsequence\t501\t560\n")
        f.write("chunk12\tsequence\t551\t610\n")
        f.write("chunk13\tsequence\t601\t660\n")
        f.write("chunk14\tsequence\t651\t710\n")
        f.write("chunk15\tsequence\t701\t760\n")
        f.write("chunk16\tsequence\t751\t810\n")
        f.write("chunk17\tsequence\t801\t860\n")
        f.write("chunk18\tsequence\t851\t910\n")
        f.write("chunk19\tsequence\t901\t960\n")
        f.write("chunk20\tsequence\t951\t1010\n")
        f.write("chunk21\tsequence\t1001\t1060\n")
        f.write("chunk22\tsequence\t1051\t1110\n")
        f.write("chunk23\tsequence\t1101\t1147\n")
        f.close()
        
    _createMapFile_of_Chunks = staticmethod ( _createMapFile_of_Chunks )
    
    
    def _createFastaFile_of_cut(fileName):
        f = open(fileName, 'w')
        f.write(">1  sequence {Cut} 1..60\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write(">2  sequence {Cut} 51..110\n")
        f.write("GTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGT\n")
        f.write(">3  sequence {Cut} 101..160\n")
        f.write("GCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCA\n")
        f.write(">4  sequence {Cut} 151..210\n")
        f.write("ATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTAT\n")
        f.write(">5  sequence {Cut} 201..260\n")
        f.write("CGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGAT\n")
        f.write(">6  sequence {Cut} 251..310\n")
        f.write("ATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGC\n")
        f.write(">7  sequence {Cut} 301..360\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write(">8  sequence {Cut} 351..410\n")
        f.write("GTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGT\n")
        f.write(">9  sequence {Cut} 401..460\n")
        f.write("GCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCA\n")
        f.write(">10  sequence {Cut} 451..510\n")
        f.write("ATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTAT\n")
        f.write(">11  sequence {Cut} 501..560\n")
        f.write("CGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGAT\n")
        f.write(">12  sequence {Cut} 551..610\n")
        f.write("ATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGC\n")
        f.write(">13  sequence {Cut} 601..660\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write(">14  sequence {Cut} 651..710\n")
        f.write("GTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGT\n")
        f.write(">15  sequence {Cut} 701..760\n")
        f.write("GCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCA\n")
        f.write(">16  sequence {Cut} 751..810\n")
        f.write("ATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTAT\n")
        f.write(">17  sequence {Cut} 801..860\n")
        f.write("CGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGAT\n")
        f.write(">18  sequence {Cut} 851..910\n")
        f.write("ATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGC\n")
        f.write(">19  sequence {Cut} 901..960\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write(">20  sequence {Cut} 951..1010\n")
        f.write("GTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGT\n")
        f.write(">21  sequence {Cut} 1001..1060\n")
        f.write("GCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCA\n")
        f.write(">22  sequence {Cut} 1051..1110\n")
        f.write("ATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCGCGCATCGATCGATCGGCGGCTAT\n")
        f.write(">23  sequence {Cut} 1101..1147\n")
        f.write("CGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTAATATTCG\n")
        f.close()
        
    _createFastaFile_of_cut = staticmethod ( _createFastaFile_of_cut )
    
    
    def _createFastaFile_of_Nstretch(fileName):
        f = open(fileName, 'w')
        f.write("")
        f.close()
        
    _createFastaFile_of_Nstretch = staticmethod ( _createFastaFile_of_Nstretch )
    
    
# ------------------ for splitSeqPerCluster ------------------- #
    
    def _createFastaFile_of_four_sequences_with_specific_header(inFileName):
        f = open(inFileName, 'w')
        f.write(">ReconCluster1Mb155 chunk183 {Fragment} 1..5506\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">MbQ3Gr2Cl0 chunk440 {Fragment} 2678..3645\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">MbS2Gr2Cl0 chunk622 {Fragment} 104..1078\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">PilerCluster3.574Mb796 chunk0117 {Fragment} 51582..50819\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createFastaFile_of_four_sequences_with_specific_header = staticmethod ( _createFastaFile_of_four_sequences_with_specific_header )
    
    
    def _createFastaFile_of_four_sequences_with_specific_header_shuffle(inFileName):
        f = open(inFileName, 'w')
        f.write(">MbQ3Gr2Cl0 chunk440 {Fragment} 2678..3645\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">ReconCluster1Mb155 chunk183 {Fragment} 1..5506\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">MbS2Gr2Cl0 chunk622 {Fragment} 104..1078\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">PilerCluster3.574Mb796 chunk0117 {Fragment} 51582..50819\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createFastaFile_of_four_sequences_with_specific_header_shuffle = staticmethod ( _createFastaFile_of_four_sequences_with_specific_header_shuffle )
    
    
    def _createFastaFile_of_four_sequences_with_specific_header_in_same_cluster(inFileName):
        f = open(inFileName, 'w')
        f.write(">ReconCluster1Mb155 chunk1 {Fragment} 1..5506\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">ReconCluster1Mb155 chunk2 {Fragment} 1..5506\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">ReconCluster1Mb155 chunk3 {Fragment} 1..5506\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">ReconCluster1Mb155 chunk4 {Fragment} 1..5506\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createFastaFile_of_four_sequences_with_specific_header_in_same_cluster = staticmethod ( _createFastaFile_of_four_sequences_with_specific_header_in_same_cluster )
    
    
    def _createFastaFile_of_first_cluster_result(inFileName):
        f = open(inFileName, 'w')
        f.write(">ReconCluster1Mb155 chunk183 {Fragment} 1..5506\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createFastaFile_of_first_cluster_result = staticmethod ( _createFastaFile_of_first_cluster_result )
    
    
    def _createFastaFile_of_second_cluster_result(inFileName):
        f = open(inFileName, 'w')
        f.write(">MbQ3Gr2Cl0 chunk440 {Fragment} 2678..3645\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">MbS2Gr2Cl0 chunk622 {Fragment} 104..1078\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createFastaFile_of_second_cluster_result = staticmethod ( _createFastaFile_of_second_cluster_result )
    
    
    def _createFastaFile_of_third_cluster_result(inFileName): 
        f = open(inFileName, 'w')
        f.write(">PilerCluster3.574Mb796 chunk0117 {Fragment} 51582..50819\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createFastaFile_of_third_cluster_result = staticmethod ( _createFastaFile_of_third_cluster_result )
    
    
    def _createFastaFile_of_first_cluster_result_with_simplify_header(inFileName):
        f = open(inFileName, 'w')
        f.write(">Piler_Cluster1_Seq155\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createFastaFile_of_first_cluster_result_with_simplify_header = staticmethod ( _createFastaFile_of_first_cluster_result_with_simplify_header )
    
    
    def _createFastaFile_of_second_cluster_result_with_simplify_header(inFileName):
        f = open(inFileName, 'w')
        f.write(">Piler_Cluster2_Seq3\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">Piler_Cluster2_Seq2\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createFastaFile_of_second_cluster_result_with_simplify_header = staticmethod ( _createFastaFile_of_second_cluster_result_with_simplify_header )
    
    
    def _createFastaFile_of_third_cluster_result_with_simplify_header(inFileName): 
        f = open(inFileName, 'w')
        f.write(">Piler_Cluster3.574_Seq796\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createFastaFile_of_third_cluster_result_with_simplify_header = staticmethod ( _createFastaFile_of_third_cluster_result_with_simplify_header )
        
# ---------------------------------- #
    
    def _createPatternFile(fileName):
        f = open(fileName, 'w')
        f.write('seq 3\n')
        f.write('f\n')
        f.write('s.q 1\n')
        f.write('q 8\n')
        
    _createPatternFile = staticmethod ( _createPatternFile )
    
        
    def _createResult_of_dbLengthFilter_sup(inFileName): 
        f = open(inFileName, 'w')
        f.write(">seq 2\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">seq 3\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">seq 4\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createResult_of_dbLengthFilter_sup = staticmethod ( _createResult_of_dbLengthFilter_sup )
    
        
    def _createFastaFile_four_sequences_for_header_filtering(fileName):
        f = open(fileName, 'w')
        f.write(">seq1_HostGene\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">seq2_SSR\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">seq3_Map2_NoCat\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.write(">seq4_confused\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCGCGCATCGATCGATCGGCGGCTATATGCTAGTCAGCTAGCTAGTGTGAGTAGTA\n")
        f.write("ATATTCG\n")
        f.close()
        
    _createFastaFile_four_sequences_for_header_filtering = staticmethod ( _createFastaFile_four_sequences_for_header_filtering )
    
   
    def _createFastaFile_three_sequences_with_ORFs(fileName):
        f = open(fileName, 'w')
        f.write(">Mivi_sl_Blaster_Grouper_1_Map_3\n")
        f.write("TACAGTCAAACCTGAGAAAATTTATATCGCCCAATCTTATACCTGGCAAAATTTATGGAC\n")
        f.write("TTTTCAATCTCCCGACTTTTTTGGCTGACAGAACCTGTCCAATCTTATACCTTATAATTT\n")
        f.write("ATGGGTTTACAGGTCAAATTATAAGATAAGAGAGAGCCGGAAATGAGCGATTGATCAGGA\n")
        f.write("ATTGGCCTCTCCTTCGGCGTTCTTGTTGACGAGCCGCCTGCTGGAACAGTCCGAAATGCC\n")
        f.write("CCGAAACAGCCGAGAAGCGAGCACAGTAGAGCAAAGGCGGCGGTTGACACGTTGACAGGC\n")
        f.write("TATTAGTCGCGACGTGCTTCTCTCTCCTCTTCCGCCGACAACGACGCCGAAATGAACATC\n")
        f.write("TTCACAATTCGAGAAGCCCTCATCAGAAATTCCTCTTCATATCATCATGGTCTCATTCCC\n")
        f.write("TTCCCGGAATTCAACTGCTGGCGCCACGCTCAAATCTTGTCTGATCGCAAGAACAAAGGA\n")
        f.write("TCGACCGACCATACACCTCTTCCCAACGGTCGCGGGCCTCTCGATGGCGATCGCGGCATC\n")
        f.write("ATCAACGCGATGAACGCTCTGAAGACGGCGAACGATGAGCTGGTCGAAAAGGGGATAGTT\n")
        f.write("ACGAGCAACGAGAAGATGAGTATCCACTTTCTCGTCGATGTGGAGGAGGAGAACCTTGCT\n")
        f.write("GGTGGGGCTGAAATGACCGATCAGGAGATTGTGGACCTGGTCATTGCCGAAGAGTTGGAG\n")
        f.write("GAGAATTGCGAGGGAGAAGGAGGAGAGGAGGAAGCGGAGATAGAGCTCCGACCGGCGGAG\n")
        f.write("CGAACGACGCTGAAGGAGGCAATCTCAGCGCTTGATGTTTTCCTTAGGTTTGCTATGAAT\n")
        f.write("GGGTACTCAGGTCCAACGGATTTGATTTCTTTTGAGGACGAGGCTAGGAGGATTCGCAGG\n")
        f.write("ACTCTTGTTGCCGAGCAGGATGCCGCGAGGATTCAGACGACAATGACTTCGTATTTCCAG\n")
        f.write("CGTCAGTAG\n")
        f.write(">Mivi_sl_Blaster_Grouper_2_Map_3\n")
        f.write("TACAGTCAGACCTGAGAAAATTTATATCGCCCAATCTTATACCTGTCAAAATTTATGGAC\n")
        f.write("TTTTCAATCTCCCGACTTTTTTGGCTGACAGAACCTGTCCAATCTTATACCTTATAATTT\n")
        f.write("ATGGGTTTACAGGTCAAATTATAAGATAAGAGAGAGCCGGAAATGAGCGATTGATCAGGA\n")
        f.write("ATTGGCCTCTCCTTCGGCGTTCTTGTTGACGAGCCGCCTGCTGGAAGAGTCCGAAATGCC\n")
        f.write("CCGAAACAGCCAAGAAGCGAGCACAGTAGAGCAAAGGCGGCGGTTGACACGTTGACAGGC\n")
        f.write("TAGTCGCGACGTGCTTCTCTCTCCTCTTCCGCCGACAACGACGCCGAAATGAACATCTTC\n")
        f.write("ACAATCCGAGAAGCCCTCATCAGAAATTCCTCTTCATATCATCATGGTCTCATTCCCTTC\n")
        f.write("CCGGAATTCAACTGCTGGCGCCACGCTCAAATCTTGTCTGATCGCAAGAACAAAGGATCG\n")
        f.write("ACCGACCATACACCTCTTCCCAACGGTCGCGGGCCTCTCGATGGCGATCGCGGCATCATC\n")
        f.write("AACGCGATGAACGCTCTGAAGACGGCGAACGATGAGCTGGTCGAAAAGGGGATAGTTACG\n")
        f.write("AGCAACGAGAAGATGAGTATCCACTTTCTCGTCGATGTGGAGGAGGAGAACCTTGCTGGT\n")
        f.write("GGGGCTGAAATGACCGATCAGGAGATTGTGGACCTGGGGTCATTGCCGAAGAGTTGGAGG\n")
        f.write("AGAATTGCGAGGGAGAACTTGAAGGAGGAGAGGAGGAAGCGGAGATAGAGCTCCGACCGG\n")
        f.write("CGGAGCGAACGACGCTGAAGGAGGCAATCTCAGCGCTTGGTGTTTTCCTTAGGTTTGCTA\n")
        f.write("TGAATGGGTACTCAGGTCCAACGAATTTGATTTCTTTTGAGGACGAGGCTAGGAGGATTC\n")
        f.write("GCAGGACTCTTGTTGCCGAGCAGGATGCCGCGAGGATTCAGACGACAATGACTTCGTATT\n")
        f.write("TCCAGCGTCAGTAGGTCAAGATATTTTTTCTTGGAGCTTTCATAACTTGTTAGATGTCAT\n")
        f.write("CATGCCTCAGTAGAGGCCGTACATTGGCTGCAATTCAGTAATTCGGGCCTTCTGAATTTC\n")
        f.write("CTCCCCCTCAAAAGTCAATGTATCGACTCAAACGATGCACGAAAATTCTTGATTTGATGT\n")
        f.write("AGGAAGCTCAAAAACGGAGTTTCAGGTCATAATGTAGTGATCTGAAGCCGAACTCTCCAA\n")
        f.write("GCTTATACCTGTCTTAATTTATGGGAAAATCCGTCCACCGAAAATATAAATTTTCTCAGG\n")
        f.write("TCTGACTGTA\n")
        f.write(">Mivi_sl_Blaster_Grouper_3_Map_3\n")
        f.write("CAACACAAAGATAAGGCACCTTCATCCAGTGGCTCGCACGAACTTTCAATTGCAAGTCGT\n")
        f.write("TGGCGTGCGCTGGGCGGGATCAAAACCGGGTCTGGGAGTCGCGTAACCCACTGGAGCAAG\n")
        f.write("TAGGTGGTAGCCTGGACTGACAACGTGGACGTCAGCGACTTGAAATAGGTATTCGCGGCT\n")
        f.write("TTCGTGGTCGGTGTACCCCTGTGTGTCCGGCATCGGCTGTCCAGAGTCGCCAGCCTGCCC\n")
        f.write("GGTGCGAATGTGGGGGGCAGTCTCGGTCGCGCACGTGCGATGTCCCTCTCCCCACACGGG\n")
        f.write("CCTGTCGGCTGCGGCTAACGGCCCCTGCAATGAGTCCTATCGACAGAAGTCCACCCAAGC\n")
        f.write("TCAGCCTTCCCTCCACCAACACCAACATCGCAAGCCTCTCAAAAATTCACATCTCTTACA\n")
        f.write("TCCCCTCGAAACACCCACTAAATGGATCCCTACCCTATCACTTGGCGGCAGTACTAGTAG\n")
        f.write("CACGGGCCCAACTTCGACGGATCTCGAACGGACTTCCCACGGGTTCTCGGTGTGCAAGCG\n")
        f.write("TCTCAGGTCAAGGTTTTGGTTGGTGGGCTTTCTGGGTGTGCAAAGGGGATTATTATAGAG\n")
        f.write("GGAAGAAGAAGAAGGATGGGACCAGGGAGGCAGAGACGTGCGGGGTCAGGTTGATGGGGG\n")
        f.write("AAGGTCGTGGAAGCGAAGAACGAGAGGCGAGCTTGTCGTTTGAGGAGAAAGGGGCCTCGC\n")
        f.write("TGCCTGCAGAGAAAGGCGGTAAGTTGACCGGCGCAAAGTTATCATGAGACCGTAGCTCAG\n")
        f.write("TATCGTTTCCTGTCGAGGGCATGGGTTACAGTCCGTCGAACTATGCGCGAGATCATCTGG\n")
        f.write("TAGTAAAGAATCCCGCCGCCACTGACCAGATCTCCTGTGTCCTCTCAGCTCTCACAAAAC\n")
        f.write("CTAGAAAAGCTTCGCATGGAGCCAAACGAATACTCCAATCCGACATTGAGCAAGACCCTT\n")
        f.write("CCCTCTCGCCTCATAGGAACGAAACGGCCCATCTTCGAAGGGACAACTCTCTGTCGGCCG\n")
        f.write("AGGAGATGACTTTTCTGACCGAGCGTAAGAGGAGATCGCACAGAGTCAGGGGTTGGTCGA\n")
        f.write("GCTTTTGGGATTGGAGGAAGGGGGAGAGATTGATGAACGAGACGTCCCAATAGTGAGTCG\n")
        f.write("CTCCGCACTGGAGCAATGATGGCAAACCGTGGAGTTGAAGAGTCTTGAACGCTATCAGAT\n")
        f.write("CGGGCTAGGAGGGTCGGGAGGCGGTTGAATGCGTGCCAACCTTGGCTTCCTGTCAACGAT\n")
        f.write("CCTCGCCTTTCAAGAGCTCGATCTATGGCAGTTGTTGACCTACACAGCGGGGGTATCCGG\n")
        f.write("GTCCTGTTGGGCTCTGGCGAGTTTATATACGCTACCGATCGCACGTCCGCTCACACCATC\n")
        f.write("CATCACTCAACGCCGCTGCGGTGATTGAGCACTTTATGTCCGTCTCAGGGGATCACCGTC\n")
        f.write("TGAGTACAAAATCGGTCAACCGAGTCAGGGAGGCACACGGAGGGTACCAATCGCTTTTCG\n")
        f.write("GACCTTTGATTTCAAAGTCTAAGAACAGTCAAAAGATCTGTAGTGAGTACAGACCACTGA\n")
        f.write("CCCTCACTTGAGTAGATATTGACACTGACGAAGATCGCTACACTGCGGGCCTTGACAGTG\n")
        f.write("ATTGATCTGTACTCGACACTGGTCTCATCGTACTTCTGGATGATGCCCAGAAAAGATGGG\n")
        f.write("AAGGATCAGGTTGATCCGTATGTACCCCTGCGTCGGCTCGTGAGGTCCAGAGAGGGTCAT\n")
        f.write("TCCACTGACTGTCCCGAACCCCCCCTGGCTGATCGTCAGCGCCTCGATGAAATGGTCGCG\n")
        f.write("CGCGTACGATAATGCGGGCCTGGCTCACGGATGCGCGCCTTTCCCTATCGTCAGTCACGC\n")
        f.write("AAATGTAGGCTTCCATCTGGAACGCTGCTTGATGGCCTAAGAATGGGCCGTCACGGAACA\n")
        f.write("GCTCACCGCCTGCAGACACGAACGGCCGTGGCGGTCATGGAAGGATCTGAACGTGTCGCC\n")
        f.write("CCATACGATTGACGAAGAGATGTAAGCTCCCTTGGTA\n")
        f.close()
    
    _createFastaFile_three_sequences_with_ORFs = staticmethod ( _createFastaFile_three_sequences_with_ORFs )
    
    
    def _createFastaFile_three_sequences_with_ORFs_expected(fileName):  
        f = open(fileName, 'w') 
        f.write("ORF|1|662\tMivi_sl_Blaster_Grouper_1_Map_3\t307\t969\n")
        f.write("ORF|-3|254\tMivi_sl_Blaster_Grouper_1_Map_3\t793\t539\n")
        f.write("ORF|2|197\tMivi_sl_Blaster_Grouper_1_Map_3\t356\t553\n")
        f.write("ORF|3|176\tMivi_sl_Blaster_Grouper_1_Map_3\t288\t464\n")
        f.write("ORF|-1|176\tMivi_sl_Blaster_Grouper_1_Map_3\t786\t610\n")
        f.write("ORF|3|143\tMivi_sl_Blaster_Grouper_1_Map_3\t672\t815\n")
        f.write("ORF|1|131\tMivi_sl_Blaster_Grouper_1_Map_3\t175\t306\n")
        f.write("ORF|-2|131\tMivi_sl_Blaster_Grouper_1_Map_3\t797\t666\n")
        f.write("ORF|2|128\tMivi_sl_Blaster_Grouper_1_Map_3\t167\t295\n")
        f.write("ORF|-2|119\tMivi_sl_Blaster_Grouper_1_Map_3\t242\t123\n")
        f.write("ORF|1|464\tMivi_sl_Blaster_Grouper_2_Map_3\t304\t768\n")
        f.write("ORF|3|305\tMivi_sl_Blaster_Grouper_2_Map_3\t669\t974\n")
        f.write("ORF|-3|251\tMivi_sl_Blaster_Grouper_2_Map_3\t1094\t843\n")
        f.write("ORF|-2|245\tMivi_sl_Blaster_Grouper_2_Map_3\t531\t286\n")
        f.write("ORF|-3|224\tMivi_sl_Blaster_Grouper_2_Map_3\t791\t567\n")
        f.write("ORF|-2|215\tMivi_sl_Blaster_Grouper_2_Map_3\t1098\t883\n")
        f.write("ORF|2|197\tMivi_sl_Blaster_Grouper_2_Map_3\t353\t550\n")
        f.write("ORF|3|173\tMivi_sl_Blaster_Grouper_2_Map_3\t288\t461\n")
        f.write("ORF|-1|173\tMivi_sl_Blaster_Grouper_2_Map_3\t1087\t914\n")
        f.write("ORF|-1|143\tMivi_sl_Blaster_Grouper_2_Map_3\t310\t167\n")
        f.write("ORF|3|626\tMivi_sl_Blaster_Grouper_3_Map_3\t141\t767\n")
        f.write("ORF|2|434\tMivi_sl_Blaster_Grouper_3_Map_3\t164\t598\n")
        f.write("ORF|3|365\tMivi_sl_Blaster_Grouper_3_Map_3\t768\t1133\n")
        f.write("ORF|-3|359\tMivi_sl_Blaster_Grouper_3_Map_3\t1514\t1155\n")
        f.write("ORF|-1|320\tMivi_sl_Blaster_Grouper_3_Map_3\t1879\t1559\n")
        f.write("ORF|3|272\tMivi_sl_Blaster_Grouper_3_Map_3\t1299\t1571\n")
        f.write("ORF|-2|248\tMivi_sl_Blaster_Grouper_3_Map_3\t1503\t1255\n")
        f.write("ORF|1|236\tMivi_sl_Blaster_Grouper_3_Map_3\t1576\t1812\n")
        f.write("ORF|-1|227\tMivi_sl_Blaster_Grouper_3_Map_3\t1423\t1196\n")
        f.write("ORF|-3|227\tMivi_sl_Blaster_Grouper_3_Map_3\t368\t141\n")
        f.close()

    _createFastaFile_three_sequences_with_ORFs_expected = staticmethod ( _createFastaFile_three_sequences_with_ORFs_expected )
    
    
    def _createLinkFile_four_sequences_with_new_headers(fileName):
        f = open(fileName, 'w')
        f.write("seq 1\tReconCluster1Mb155 chunk183 {Fragment} 1..5506\t1\t127\n")
        f.write("seq 2\tMbQ3Gr2Cl0 chunk440 {Fragment} 2678..3645\t1\t307\n")
        f.write("seq 3\tMbS2Gr2Cl0 chunk622 {Fragment} 104..1078\t1\t427\n")
        f.write("seq 4\tPilerCluster3.574Mb796 chunk0117 {Fragment} 51582..50819\t1\t307\n")
        
    _createLinkFile_four_sequences_with_new_headers = staticmethod ( _createLinkFile_four_sequences_with_new_headers )
    
    
    def _createLinkFile_four_sequences_same_headers(fileName):
        f = open(fileName, 'w')
        f.write("seq 1\tseq 1\t1\t127\n")
        f.write("seq 2\tseq 2\t1\t307\n")
        f.write("seq 3\tseq 3\t1\t427\n")
        f.write("seq 4\tseq 4\t1\t307\n")
        
    _createLinkFile_four_sequences_same_headers = staticmethod ( _createLinkFile_four_sequences_same_headers )
