#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
"""Restrict a transcript list with some parameters (regions)"""

from optparse import OptionParser
from SMART.Java.Python.structure.TranscriptContainer import TranscriptContainer
from commons.core.writer.TranscriptWriter import TranscriptWriter
from SMART.Java.Python.misc.Progress import Progress

STRAND2DIRECTION = {"+": 1, "-": -1, None: None}

if __name__ == "__main__":
    
    # parse command line
    description = "Restrict Transcript List v1.0.2: Keep the coordinates which are located in a given position. [Category: Data Selection]"

    parser = OptionParser(description = description)
    parser.add_option("-i", "--input",      dest="inputFileName",  action="store",                             type="string", help="input file [compulsory] [format: file in transcript format given by -f]")
    parser.add_option("-f", "--format",     dest="format",         action="store",                             type="string", help="format [compulsory] [format: transcript file format]")
    parser.add_option("-c", "--chromosome", dest="chromosome",     action="store",            default=None,    type="string", help="chromosome [format: string]")
    parser.add_option("-s", "--start",      dest="start",          action="store",            default=None,    type="int",    help="start [format: int]")
    parser.add_option("-e", "--end",        dest="end",            action="store",            default=None,    type="int",    help="end [format: int]")
    parser.add_option("-t", "--strand",     dest="strand",         action="store",            default=None,    type="string", help="strand (+ or -) [format: string]")
    parser.add_option("-o", "--output",     dest="outputFileName", action="store",                             type="string", help="output file [format: output file in GFF3 format]")
    parser.add_option("-v", "--verbosity",  dest="verbosity",      action="store",            default=1,       type="int",    help="trace level [format: int]")
    (options, args) = parser.parse_args()

    parser = TranscriptContainer(options.inputFileName, options.format, options.verbosity)
    writer = TranscriptWriter(options.outputFileName, options.format, options.verbosity)

    direction = STRAND2DIRECTION[options.strand]
        
    nbTranscripts = parser.getNbTranscripts()
    progress      = Progress(nbTranscripts, "Parsing file %s" % (options.inputFileName), options.verbosity)
    
    nbTotal = 0
    nbKept    = 0
    for transcript in parser.getIterator():
        progress.inc()
        nbTotal += 1
        if options.chromosome != None and options.chromosome != transcript.getChromosome():
            continue
        if options.start != None and options.start > transcript.getEnd():
            continue
        if options.end != None and options.end < transcript.getStart():
            continue
        if options.end != None and options.end < transcript.getStart():
            continue
        if direction != None and direction != transcript.getDirection():
            continue
        nbKept += 1
        writer.addTranscript(transcript)
    progress.done()
    
    writer.write()
        
    print "%d out of %d are kept (%f%%)" % (nbKept, nbTotal, (float(nbKept) / nbTotal * 100))        
