#!/usr/bin/env python

# Copyright INRA (Institut National de la Recherche Agronomique)
# http://www.inra.fr
# http://urgi.versailles.inra.fr
#
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software.  You can  use, 
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info". 
#
# As a counterpart to the access to the source code and  rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty  and the software's author,  the holder of the
# economic rights,  and the successive licensors  have only  limited
# liability. 
#
# In this respect, the user's attention is drawn to the risks associated
# with loading,  using,  modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean  that it is complicated to manipulate,  and  that  also
# therefore means  that it is reserved for developers  and  experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or 
# data to be ensured and,  more generally, to use and operate it in the 
# same conditions as regards security. 
#
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.

import sys
import os
import shutil
from commons.core.utils.FileUtils import FileUtils

class PipelineStepFTests(object):
    
    def __init__(self, pipelineName, packageDir, workingDir, projectName, config = "", clean = True):
        self._pipelineName = pipelineName
        self._packageDir = packageDir
        self._workingDir = workingDir
        self._projectName = projectName
        self._clean = clean
        self._configFileName = config
        
    def run(self):
        self.launchStep()
        self.assertStep()

#    def replaceInFile(self, fileName, oldPattern, newPattern, newFileName = ""):
#        if newFileName == "":
#            newFileName = "%s.new" % fileName
#        f = open(newFileName, "w")
#        for line in fileinput.input(fileName, inplace=1):
#            newLine = line.replace(oldPattern, newPattern)
#            f.write(newLine)
#        f.close()
#        fileinput.close()

    def _checkIfFileExist(self, fileName):
        if not FileUtils.isRessourceExists(fileName):
            print "%s do not exists\n" % fileName
            return False
        return True
        
    def _printMessageAndClean(self, msg):
        print "%s in %s functional test\n" % (msg, self._pipelineName)
        sys.stdout.flush()
        os.chdir("../")
        if self._clean:
            shutil.rmtree(self._workingDir)
                
    def _areTwoFilesIdenticalByScript( self, expFileName, obsFileName, scriptName):
        cmd = "%s -v 1 -r %s -t %s 2>/dev/null" % (scriptName, expFileName, obsFileName)
        log = os.system(cmd)
        print
        sys.stdout.flush()
        if log != 0:
            return False
        else:
            return True