#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
import random
from SMART.Java.Python.structure.Interval import Interval
from SMART.Java.Python.mySql.MySqlTable import MySqlTable


class MySqlExonTable(MySqlTable):
    """A table of exon in a mySQL database"""

    def __init__(self, connection, name = None, chromosome = None, verbosity = 0):
        if chromosome == None:
            chromosome = ""
        else:
            chromosome = "_%s" % chromosome
        if name == None:
            name = "TmpTable_%d" % (random.randint(0, 100000))
        name = "%s%s_exons" % (name, chromosome)
        super(MySqlExonTable, self).__init__(connection, name, verbosity)


    def createExonTable(self):
        variables = Interval.getSqlVariables()
        variables.append("transcriptId")
        types = Interval.getSqlTypes()
        types["transcriptId"] = "int"
        sizes = Interval.getSqlSizes()
        sizes["transcriptId"] = 11
        self.create(variables, types, sizes)


    def rename(self, name):
        super(MySqlExonTable, self).rename("%s_exons" % name)
    
        
    def addExon(self, exon, transcriptId):
        values = exon.getSqlValues()
        values["transcriptId"] = transcriptId
        id = self.addLine(values)
        exon.id = id


    def retrieveExonsFromTranscriptId(self, transcriptId):
        if not self.created:
            return []
        query = self.mySqlConnection.executeQuery("SELECT * FROM %s WHERE transcriptId = %d" % (self.name, transcriptId))
        exons = []
        for exonLine in query.getIterator():
            exon = Interval()
            exon.setSqlValues(exonLine)
            exons.append(exon)
        return exons
            

    def retrieveExonsFromBulkTranscriptIds(self, transcriptIds):
        if not transcriptIds:
            return {}
        if not self.created:
            return {}
        exons = dict([(transcriptId, []) for transcriptId in transcriptIds])
        query = self.mySqlConnection.executeQuery("SELECT * FROM %s WHERE transcriptId IN (%s)" % (self.name, ", ".join(["%s" % (transcriptId) for transcriptId in transcriptIds])))
        for exonLine in query.getIterator():
            exon = Interval()
            exon.setSqlValues(exonLine)
            exons[exonLine[-1]].append(exon)
        return exons
            

    def removeFromTranscriptId(self, transcriptId):
        self.mySqlConnection.executeQuery("DELETE FROM %s WHERE transcriptId = %d" % (self.name, transcriptId))
