#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
import sys
from commons.core.parsing.TranscriptListParser import TranscriptListParser
from commons.core.parsing.MapperParser import MapperParser
from commons.core.parsing.SequenceListParser import SequenceListParser
from commons.core.parsing.BedParser import BedParser
from commons.core.parsing.GffParser import GffParser
from commons.core.parsing.MapperParser import MapperParser
from commons.core.parsing.CoordsParser import CoordsParser
from commons.core.parsing.SeqmapParser import SeqmapParser
from commons.core.parsing.SoapParser import SoapParser
from commons.core.parsing.Soap2Parser import Soap2Parser
from commons.core.parsing.BlastParser import BlastParser
from commons.core.parsing.PslParser import PslParser
from commons.core.parsing.RmapParser import RmapParser
from commons.core.parsing.ShrimpParser import ShrimpParser
from commons.core.parsing.AxtParser import AxtParser
from commons.core.parsing.ExoParser import ExoParser
from commons.core.parsing.MaqParser import MaqParser
from commons.core.parsing.SamParser import SamParser
from commons.core.parsing.BamParser import BamParser
from commons.core.parsing.BowtieParser import BowtieParser
from commons.core.parsing.ElandParser import ElandParser
from commons.core.parsing.GtfParser import GtfParser
from commons.core.parsing.FastaParser import FastaParser
from commons.core.parsing.FastqParser import FastqParser
from commons.core.parsing.MapParser import MapParser
from commons.core.parsing.WigParser import WigParser
from commons.core.parsing.NCListParser import NCListParser
from commons.core.parsing.PklParser import PklParser

#Attention!! Do not delete the imports!! They are used to know the type of file format!!!

class ParserChooser(object):
    """
    A class that finds the correct parser
    @ivar format: the format
    @type format: string
    @ivar type: transcript / mapping / sequence parser
    @type type: string
    @ivar parser: the parser
    @type parser: object
    @ivar verbosity: verbosity
    @type verbosity: int        
    """

    def __init__(self, verbosity = 0):
        """
        Constructor
        @param verbosity: verbosity
        @type verbosity: int
        """
        self.type = None
        self.parserClass = None
        self.verbosity = verbosity
    

    def findFormat(self, format, type = None):
        """
        Find the correct parser
        @ivar format: the format
        @type format: string
        @ivar type: transcript / mapping / sequence parser (None is all)
        @type type: string
        @return: a parser
        """
        classes = {}
        if (type == "transcript"):
            classes = {TranscriptListParser: "transcript"}
        elif (type == "mapping"):
            classes = {MapperParser: "mapping"}
        elif (type == "sequence"):
            classes = {SequenceListParser: "sequence"}
        elif (type == None):
            classes = {TranscriptListParser: "transcript", MapperParser: "mapping", SequenceListParser: "sequence"}
        else:
            raise Exception("Do not understand format type '%s'" % (type))

        for classType in classes:
            for parserClass in classType.__subclasses__():
                if format in parserClass.getFileFormats():
                    self.parserClass = parserClass
                    self.type = classes[classType]
                    return
        raise Exception("Cannot get parser for format '%s'" % (format))


    def getParser(self, fileName):
        """
        Get the parser previously found
        @return: the parser
        """
        return self.parserClass(fileName, self.verbosity)


    def getType(self):
        """
        Get the type of parser previously found
        @return: the type of parser
        """
        return self.type
