import unittest
from SMART.Java.Python.structure.Interval import Interval
from SMART.Java.Python.structure.SubMapping import SubMapping

class Test_SubMapping(unittest.TestCase):

    def test__init__(self):
        expEvalue = 0.00
        expScore = 0
        expIdentity = 0.00
        expTargetInterval = Interval()
        expQueryInterval = Interval()
        expQueryRange = expQueryInterval
        expSubjectRange = expTargetInterval
        expSize = None
        expTags = {}
        
        iSubMapping = SubMapping()
        obsQueryRange = iSubMapping.getQueryAsRange()
        obsSubjectRange = iSubMapping.getSubjectAsRange()
        obsEvalue = iSubMapping.getEvalue()
        obsScore = iSubMapping.getScore()
        obsIdentity = iSubMapping.getIdentity()
        obsTargetInterval = iSubMapping.getTargetInterval()
        obsQueryInterval = iSubMapping.getQueryInterval()
        obsSize = iSubMapping.getSize()
        obsTags = iSubMapping.getTags()
        
        self.assertEquals(expEvalue, obsEvalue)
        self.assertEquals(expIdentity, obsIdentity)
        self.assertEquals(expQueryInterval, obsQueryInterval)
        self.assertEquals(expQueryRange, obsQueryRange)
        self.assertEquals(expScore, obsScore)
        self.assertEquals(expSize, obsSize)
        self.assertEquals(expSubjectRange, obsSubjectRange)
        self.assertEquals(expTags, obsTags)
        self.assertEquals(expTargetInterval, obsTargetInterval)
        
    def test__init__change_values_by_Interval(self):
        iSubMapping = SubMapping()
        
        expSeqName = ""
        
        obsRangeSubject = iSubMapping.range_subject.getSeqname()
        obsRangeQuery = iSubMapping.range_query.getSeqname()
        obsIntervalTarget = iSubMapping.getTargetInterval().getChromosome()
        obsIntervalQuery = iSubMapping.getQueryInterval().getChromosome()
        
        self.assertEquals(expSeqName, obsRangeSubject)
        self.assertEquals(expSeqName, obsRangeQuery)
        self.assertEquals(expSeqName, obsIntervalTarget)
        self.assertEquals(expSeqName, obsIntervalQuery)
        
        iSubMapping.getTargetInterval().setChromosome("intervalTarget")
        iSubMapping.getQueryInterval().setChromosome("intervalQuery")
        
        expTargetSeqName = "intervalTarget"
        expQuerySeqName = "intervalQuery"
        
        obsRangeSubject = iSubMapping.range_subject.getSeqname()
        obsRangeQuery = iSubMapping.range_query.getSeqname()
        obsIntervalTarget = iSubMapping.getTargetInterval().getChromosome()
        obsIntervalQuery = iSubMapping.getQueryInterval().getChromosome()
        
        self.assertEquals(expTargetSeqName, obsRangeSubject)
        self.assertEquals(expQuerySeqName, obsRangeQuery)
        self.assertEquals(expTargetSeqName, obsIntervalTarget)
        self.assertEquals(expQuerySeqName, obsIntervalQuery)
        
    def test__init__change_values_by_Align(self):
        iSubMapping = SubMapping()
        
        expSeqName = ""
        
        obsRangeSubject = iSubMapping.range_subject.getSeqname()
        obsRangeQuery = iSubMapping.range_query.getSeqname()
        obsIntervalTarget = iSubMapping.getTargetInterval().getChromosome()
        obsIntervalQuery = iSubMapping.getQueryInterval().getChromosome()
        
        self.assertEquals(expSeqName, obsRangeSubject)
        self.assertEquals(expSeqName, obsRangeQuery)
        self.assertEquals(expSeqName, obsIntervalTarget)
        self.assertEquals(expSeqName, obsIntervalQuery)
        
        iSubMapping.range_subject.setSeqName("intervalTarget")
        iSubMapping.range_query.setSeqName("intervalQuery")
        
        expTargetSeqName = "intervalTarget"
        expQuerySeqName = "intervalQuery"
        
        obsRangeSubject = iSubMapping.range_subject.getSeqname()
        obsRangeQuery = iSubMapping.range_query.getSeqname()
        obsIntervalTarget = iSubMapping.getTargetInterval().getChromosome()
        obsIntervalQuery = iSubMapping.getQueryInterval().getChromosome()
        
        self.assertEquals(expTargetSeqName, obsRangeSubject)
        self.assertEquals(expQuerySeqName, obsRangeQuery)
        self.assertEquals(expTargetSeqName, obsIntervalTarget)
        self.assertEquals(expQuerySeqName, obsIntervalQuery)
  
    def test__eq__(self):
        iSubMapping1 = SubMapping()
        iSubMapping1.setQueryName("Query")
        iSubMapping1.setQueryStart(50)
        iSubMapping1.setQueryEnd(150)
        iSubMapping1.setSubjectName("Subject")
        iSubMapping1.setSubjectStart(100)
        iSubMapping1.setSubjectEnd(200)
        iSubMapping1.e_value = 1e-20
        iSubMapping1.score = 30
        iSubMapping1.identity = 90.2         
        iInterval1 = Interval()
        iInterval1.setChromosome("chromosome1")
        iInterval1.setStart(0)
        iInterval1.setEnd(100)
        iInterval1.setDirection("+")
        iInterval2 = Interval()
        iInterval2.setChromosome("chromosome2")
        iInterval2.setStart(200)
        iInterval2.setEnd(300)
        iInterval2.setDirection("+")
        iSubMapping1.setTargetInterval(iInterval1)
        iSubMapping1.setQueryInterval(iInterval2)
        iSubMapping1.setTagValue("name", 50)
        iSubMapping1.setSize(100)
        
        iSubMapping2 = SubMapping()
        iSubMapping2.setQueryName("Query")
        iSubMapping2.setQueryStart(50)
        iSubMapping2.setQueryEnd(150)
        iSubMapping2.setSubjectName("Subject")
        iSubMapping2.setSubjectStart(100)
        iSubMapping2.setSubjectEnd(200)
        iSubMapping2.e_value = 1e-20
        iSubMapping2.score = 30
        iSubMapping2.identity = 90.2 
        iSubMapping2.setTargetInterval(iInterval1)
        iSubMapping2.setQueryInterval(iInterval2)
        iSubMapping2.setTagValue("name", 50)
        iSubMapping2.setSize(100)
        self.assertEqual(iSubMapping1, iSubMapping2)
        
        
    def test__eq__withInitialValue(self):
        iSubMapping1 = SubMapping()
        iInterval1 = Interval()
        iInterval2 = Interval()
        iSubMapping1.setTargetInterval(iInterval1)
        iSubMapping1.setQueryInterval(iInterval2)
        iSubMapping1.setTagValue("name", 50)
        iSubMapping1.setSize(100)
        
        iSubMapping2 = SubMapping()
        iSubMapping2.setTargetInterval(iInterval1)
        iSubMapping2.setQueryInterval(iInterval2)
        iSubMapping2.setTagValue("name", 50)
        iSubMapping2.setSize(100)
        self.assertEqual(iSubMapping1, iSubMapping2)       
              
              
    def test__init__with_copy(self):
        iTestSubMapping = SubMapping()
        iTestSubMapping.setQueryName("Query")
        iTestSubMapping.setQueryStart(50)
        iTestSubMapping.setQueryEnd(150)
        iTestSubMapping.setSubjectName("Subject")
        iTestSubMapping.setSubjectStart(100)
        iTestSubMapping.setSubjectEnd(200)
        iTestSubMapping.e_value = 1e-20
        iTestSubMapping.score = 30
        iTestSubMapping.identity = 90.2 
        
        iIntervalTarget = Interval()
        iIntervalTarget.setChromosome("chromosomeTarget")
        iIntervalTarget.setName("sequenceTarget")
        iIntervalTarget.setStart(0)
        iIntervalTarget.setEnd(123)
        iIntervalTarget.setDirection("+")
        iIntervalQuery = Interval()
        iIntervalQuery.setChromosome("chromosomeQuery")
        iIntervalQuery.setName("sequenceQuery")
        iIntervalQuery.setStart(200)
        iIntervalQuery.setEnd(323)
        iIntervalQuery.setDirection("+")    
        
        iTestSubMapping.setQueryInterval(iIntervalTarget)
        iTestSubMapping.setTargetInterval(iIntervalQuery)
        iTestSubMapping.setTagValue("identity", 50)
        iTestSubMapping.setSize(10)
        
        iSubMappingWithCopy = SubMapping(iTestSubMapping)
        self.assertEquals(iSubMappingWithCopy, iTestSubMapping)        

      
    def test_copy(self):
        iSubMapping = SubMapping()
        iSubMapping.setQueryName("Query")
        iSubMapping.setQueryStart(50)
        iSubMapping.setQueryEnd(150)
        iSubMapping.setSubjectName("Subject")
        iSubMapping.setSubjectStart(100)
        iSubMapping.setSubjectEnd(200)
        iSubMapping.e_value = 1e-20
        iSubMapping.score = 30
        iSubMapping.identity = 90.2 
               
        iInterval1 = Interval()
        iInterval1.setChromosome("chromosome1")
        iInterval1.setName("sequence1")
        iInterval1.setStart(0)
        iInterval1.setEnd(123)
        iInterval1.setDirection("+")
        iInterval2 = Interval()
        iInterval2.setChromosome("chromosome2")
        iInterval2.setName("sequence2")
        iInterval2.setStart(200)
        iInterval2.setEnd(300)     
        iInterval2.setDirection("+")           
        iSubMapping.setQueryInterval(iInterval1)
        iSubMapping.setTargetInterval(iInterval2)
        iSubMapping.setTagValue("identity", 50)
        iSubMapping.setSize(10)

        iSubMappingCopy = SubMapping()
        iSubMappingCopy.copy(iSubMapping)
        self.assertEqual(iSubMappingCopy, iSubMapping)
        
        
    def test_setTags(self):
        iSubMapping = SubMapping()
        iSubMapping.getQueryInterval().setSize(50)
        iSubMapping.getTargetInterval().setSize(2)
        iSubMapping.setTagValue("identity", 50)
        iSubMapping.setSize(10)
        
        expQueryIntervalSize = 50
        expTargetIntervalSize = 2
        expTags = {"identity" : 50,
                   "nbMismatches" : 5}
        
        obsTags = iSubMapping.getTags()
        self.assertEquals(expTags, obsTags)
        
        
    def test_setIdentity(self):
        iSubMapping = SubMapping()        
        iSubMapping.setIdentity(10)
        expIdentity = 10
        expTags = {"identity": 10}
        
        obsIdentity = iSubMapping.getIdentity()
        obsTags = iSubMapping.getTags()
        
        self.assertEquals(expIdentity,obsIdentity)
        self.assertEquals(expTags,obsTags)
        
        
    def test_setIdentity_with_size(self):
        iSubMapping = SubMapping()        
        iSubMapping.setSize(10)
        iSubMapping.setIdentity(50)
        
        expIdentity = 50
        expTags = {"identity" : 50,
                   "nbMismatches" : 5}
        
        obsIdentity = iSubMapping.getIdentity()
        obsTags = iSubMapping.getTags()
        
        self.assertEquals(expIdentity,obsIdentity)
        self.assertEquals(expTags,obsTags)
        
        
    def test_setIdentity_with_sizeAndMismatchTag(self):
        iSubMapping = SubMapping()        
        iSubMapping.setSize(10)
        iSubMapping.setTagValue("nbMismatches", 8)
        iSubMapping.setIdentity(50)
        
        expIdentity = 50
        expTags = {"identity" : 50,
                   "nbMismatches" : 8}
        
        obsIdentity = iSubMapping.getIdentity()
        obsTags = iSubMapping.getTags()
        
        self.assertEquals(expIdentity,obsIdentity)
        self.assertEquals(expTags,obsTags)
        
        
if __name__ == "__main__":
    unittest.main()
