#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
import re
import sys
from SMART.Java.Python.structure.SubMapping import SubMapping
from SMART.Java.Python.structure.Mapping import Mapping
from SMART.Java.Python.structure.Interval import Interval
from commons.core.parsing.MapperParser import MapperParser


class NucmerParser(MapperParser):
    """A class that parses the output of Nucmer"""

    def __init__(self, fileName, verbosity = 0):
        super(NucmerParser, self).__init__(fileName, verbosity)


    def __del__(self):
        super(NucmerParser, self).__del__()


    def getFileFormats():
        return ["nucmer"]
    getFileFormats = staticmethod(getFileFormats)


    def skipFirstLines(self):
        pass


    def parseLine(self, line):
        if not line:
            return None
        if line[0] == ">":
            self.currentChromosome = line[1:].split()[0]
            return None
        splittedLine = line.strip().split()
        if len(splittedLine) != 8:
            raise Exception("Line %d '%s' does not have a NucMer format" % (self.currentLineNb, line))

        subMapping = SubMapping()

        subMapping.targetInterval.setChromosome(self.currentChromosome)
        subMapping.targetInterval.setName(self.currentChromosome)
        subMapping.targetInterval.setStart(min(int(splittedLine[0]), int(splittedLine[1])))
        subMapping.targetInterval.setEnd(max(int(splittedLine[0]), int(splittedLine[1])))
        subMapping.targetInterval.setDirection(splittedLine[6])

        subMapping.queryInterval.setChromosome(splittedLine[7])
        subMapping.queryInterval.setName(splittedLine[7])
        subMapping.queryInterval.setStart(1)
        subMapping.queryInterval.setEnd(int(splittedLine[3]))
        subMapping.queryInterval.setDirection("+")

        mapping = Mapping()
        mapping.addSubMapping(subMapping)
        mapping.setDirection(splittedLine[6])
        mapping.setIdentity(float(splittedLine[5]))
        mapping.setSize(int(splittedLine[3]))

        return mapping
