#! /usr/bin/env python
import random
from structure.interval import *
from mySql.mySqlTable import *


class MySqlExonTable(MySqlTable):
  """A table of exon in a mySQL database"""

  def __init__(self, name = None, chromosome = None, verbosity = 0):
    if chromosome == None:
      chromosome = ""
    else:
      chromosome = "_%s" % chromosome
    if name == None:
      name = "TmpTable_%d" % (random.randint(0, 100000))
    name = "%s%s_exons" % (name, chromosome)
    super(MySqlExonTable, self).__init__(name, verbosity)


  def createExonTable(self):
    variables = Interval.getSqlVariables()
    variables.append("transcriptId")
    types = Interval.getSqlTypes()
    types["transcriptId"] = "int"
    sizes = Interval.getSqlSizes()
    sizes["transcriptId"] = 11
    self.create(variables, types, sizes)


  def rename(self, name):
    super(MySqlExonTable, self).rename("%s_exons" % name)
  
    
  def addExon(self, exon, transcriptId):
    values                 = exon.getSqlValues()
    values["transcriptId"] = transcriptId
    id                     = self.addLine(values)
    exon.id                = id


  def retrieveExonsFromTranscriptId(self, transcriptId):
    query = self.mySqlConnection.executeQuery("SELECT * FROM %s WHERE transcriptId = %d" % (self.name, transcriptId))
    exons = []
    for exonLine in query.getIterator():
      exon = Interval()
      exon.setSqlValues(exonLine)
      exons.append(exon)
    return exons
      

  def removeFromTranscriptId(self, transcriptId):
    self.mySqlConnection.executeQuery("DELETE FROM %s WHERE transcriptId = %d" % (self.name, transcriptId))
